@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.inputs

import com.pulumi.aws.budgets.inputs.BudgetActionDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property iamActionDefinition The AWS Identity and Access Management (IAM) action definition details. See IAM Action Definition.
 * @property scpActionDefinition The service control policies (SCPs) action definition details. See SCP Action Definition.
 * @property ssmActionDefinition The AWS Systems Manager (SSM) action definition details. See SSM Action Definition.
 */
public data class BudgetActionDefinitionArgs(
    public val iamActionDefinition: Output<BudgetActionDefinitionIamActionDefinitionArgs>? = null,
    public val scpActionDefinition: Output<BudgetActionDefinitionScpActionDefinitionArgs>? = null,
    public val ssmActionDefinition: Output<BudgetActionDefinitionSsmActionDefinitionArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.budgets.inputs.BudgetActionDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.budgets.inputs.BudgetActionDefinitionArgs =
        com.pulumi.aws.budgets.inputs.BudgetActionDefinitionArgs.builder()
            .iamActionDefinition(
                iamActionDefinition?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .scpActionDefinition(
                scpActionDefinition?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .ssmActionDefinition(
                ssmActionDefinition?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [BudgetActionDefinitionArgs].
 */
@PulumiTagMarker
public class BudgetActionDefinitionArgsBuilder internal constructor() {
    private var iamActionDefinition: Output<BudgetActionDefinitionIamActionDefinitionArgs>? = null

    private var scpActionDefinition: Output<BudgetActionDefinitionScpActionDefinitionArgs>? = null

    private var ssmActionDefinition: Output<BudgetActionDefinitionSsmActionDefinitionArgs>? = null

    /**
     * @param value The AWS Identity and Access Management (IAM) action definition details. See IAM Action Definition.
     */
    @JvmName("svypttnaeglsaebk")
    public suspend fun iamActionDefinition(`value`: Output<BudgetActionDefinitionIamActionDefinitionArgs>) {
        this.iamActionDefinition = value
    }

    /**
     * @param value The service control policies (SCPs) action definition details. See SCP Action Definition.
     */
    @JvmName("ucfooqbqydcrneji")
    public suspend fun scpActionDefinition(`value`: Output<BudgetActionDefinitionScpActionDefinitionArgs>) {
        this.scpActionDefinition = value
    }

    /**
     * @param value The AWS Systems Manager (SSM) action definition details. See SSM Action Definition.
     */
    @JvmName("fqbxttkviifisnns")
    public suspend fun ssmActionDefinition(`value`: Output<BudgetActionDefinitionSsmActionDefinitionArgs>) {
        this.ssmActionDefinition = value
    }

    /**
     * @param value The AWS Identity and Access Management (IAM) action definition details. See IAM Action Definition.
     */
    @JvmName("drypbqsctxejkrrm")
    public suspend fun iamActionDefinition(`value`: BudgetActionDefinitionIamActionDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamActionDefinition = mapped
    }

    /**
     * @param argument The AWS Identity and Access Management (IAM) action definition details. See IAM Action Definition.
     */
    @JvmName("sresxsjkkqeadrwp")
    public suspend fun iamActionDefinition(argument: suspend BudgetActionDefinitionIamActionDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = BudgetActionDefinitionIamActionDefinitionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.iamActionDefinition = mapped
    }

    /**
     * @param value The service control policies (SCPs) action definition details. See SCP Action Definition.
     */
    @JvmName("datndpntrwlxdjaj")
    public suspend fun scpActionDefinition(`value`: BudgetActionDefinitionScpActionDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scpActionDefinition = mapped
    }

    /**
     * @param argument The service control policies (SCPs) action definition details. See SCP Action Definition.
     */
    @JvmName("gyanxlakhapmektk")
    public suspend fun scpActionDefinition(argument: suspend BudgetActionDefinitionScpActionDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = BudgetActionDefinitionScpActionDefinitionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.scpActionDefinition = mapped
    }

    /**
     * @param value The AWS Systems Manager (SSM) action definition details. See SSM Action Definition.
     */
    @JvmName("higigiyoofmrlniy")
    public suspend fun ssmActionDefinition(`value`: BudgetActionDefinitionSsmActionDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssmActionDefinition = mapped
    }

    /**
     * @param argument The AWS Systems Manager (SSM) action definition details. See SSM Action Definition.
     */
    @JvmName("xdimxytuvrpqlwex")
    public suspend fun ssmActionDefinition(argument: suspend BudgetActionDefinitionSsmActionDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = BudgetActionDefinitionSsmActionDefinitionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ssmActionDefinition = mapped
    }

    internal fun build(): BudgetActionDefinitionArgs = BudgetActionDefinitionArgs(
        iamActionDefinition = iamActionDefinition,
        scpActionDefinition = scpActionDefinition,
        ssmActionDefinition = ssmActionDefinition,
    )
}
