@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.inputs

import com.pulumi.aws.budgets.inputs.BudgetActionSubscriberArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property address The address that AWS sends budget notifications to, either an SNS topic or an email.
 * @property subscriptionType The type of notification that AWS sends to a subscriber. Valid values are `SNS` or `EMAIL`.
 */
public data class BudgetActionSubscriberArgs(
    public val address: Output<String>,
    public val subscriptionType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.budgets.inputs.BudgetActionSubscriberArgs> {
    override fun toJava(): com.pulumi.aws.budgets.inputs.BudgetActionSubscriberArgs =
        com.pulumi.aws.budgets.inputs.BudgetActionSubscriberArgs.builder()
            .address(address.applyValue({ args0 -> args0 }))
            .subscriptionType(subscriptionType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BudgetActionSubscriberArgs].
 */
@PulumiTagMarker
public class BudgetActionSubscriberArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    private var subscriptionType: Output<String>? = null

    /**
     * @param value The address that AWS sends budget notifications to, either an SNS topic or an email.
     */
    @JvmName("adrgorjnayhtcnvl")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value The type of notification that AWS sends to a subscriber. Valid values are `SNS` or `EMAIL`.
     */
    @JvmName("erutebacwujqbsny")
    public suspend fun subscriptionType(`value`: Output<String>) {
        this.subscriptionType = value
    }

    /**
     * @param value The address that AWS sends budget notifications to, either an SNS topic or an email.
     */
    @JvmName("eooeondfehlewqsh")
    public suspend fun address(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param value The type of notification that AWS sends to a subscriber. Valid values are `SNS` or `EMAIL`.
     */
    @JvmName("eqdlqadinwaqalny")
    public suspend fun subscriptionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscriptionType = mapped
    }

    internal fun build(): BudgetActionSubscriberArgs = BudgetActionSubscriberArgs(
        address = address ?: throw PulumiNullFieldException("address"),
        subscriptionType = subscriptionType ?: throw PulumiNullFieldException("subscriptionType"),
    )
}
