@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.inputs

import com.pulumi.aws.budgets.inputs.BudgetAutoAdjustDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property autoAdjustType (Required) - The string that defines whether your budget auto-adjusts based on historical or forecasted data. Valid values: `FORECAST`,`HISTORICAL`
 * @property historicalOptions (Optional) - Configuration block of Historical Options. Required for `auto_adjust_type` of `HISTORICAL` Configuration block that defines the historical data that your auto-adjusting budget is based on.
 * @property lastAutoAdjustTime (Optional) - The last time that your budget was auto-adjusted.
 */
public data class BudgetAutoAdjustDataArgs(
    public val autoAdjustType: Output<String>,
    public val historicalOptions: Output<BudgetAutoAdjustDataHistoricalOptionsArgs>? = null,
    public val lastAutoAdjustTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.budgets.inputs.BudgetAutoAdjustDataArgs> {
    override fun toJava(): com.pulumi.aws.budgets.inputs.BudgetAutoAdjustDataArgs =
        com.pulumi.aws.budgets.inputs.BudgetAutoAdjustDataArgs.builder()
            .autoAdjustType(autoAdjustType.applyValue({ args0 -> args0 }))
            .historicalOptions(historicalOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .lastAutoAdjustTime(lastAutoAdjustTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BudgetAutoAdjustDataArgs].
 */
@PulumiTagMarker
public class BudgetAutoAdjustDataArgsBuilder internal constructor() {
    private var autoAdjustType: Output<String>? = null

    private var historicalOptions: Output<BudgetAutoAdjustDataHistoricalOptionsArgs>? = null

    private var lastAutoAdjustTime: Output<String>? = null

    /**
     * @param value (Required) - The string that defines whether your budget auto-adjusts based on historical or forecasted data. Valid values: `FORECAST`,`HISTORICAL`
     */
    @JvmName("eppnhlgtayimqfnd")
    public suspend fun autoAdjustType(`value`: Output<String>) {
        this.autoAdjustType = value
    }

    /**
     * @param value (Optional) - Configuration block of Historical Options. Required for `auto_adjust_type` of `HISTORICAL` Configuration block that defines the historical data that your auto-adjusting budget is based on.
     */
    @JvmName("nraaqiopisybdbqo")
    public suspend fun historicalOptions(`value`: Output<BudgetAutoAdjustDataHistoricalOptionsArgs>) {
        this.historicalOptions = value
    }

    /**
     * @param value (Optional) - The last time that your budget was auto-adjusted.
     */
    @JvmName("xadcwbfhbcfukngf")
    public suspend fun lastAutoAdjustTime(`value`: Output<String>) {
        this.lastAutoAdjustTime = value
    }

    /**
     * @param value (Required) - The string that defines whether your budget auto-adjusts based on historical or forecasted data. Valid values: `FORECAST`,`HISTORICAL`
     */
    @JvmName("kyubkxrdqboqnbfc")
    public suspend fun autoAdjustType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoAdjustType = mapped
    }

    /**
     * @param value (Optional) - Configuration block of Historical Options. Required for `auto_adjust_type` of `HISTORICAL` Configuration block that defines the historical data that your auto-adjusting budget is based on.
     */
    @JvmName("usligpaslpcmavoi")
    public suspend fun historicalOptions(`value`: BudgetAutoAdjustDataHistoricalOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.historicalOptions = mapped
    }

    /**
     * @param argument (Optional) - Configuration block of Historical Options. Required for `auto_adjust_type` of `HISTORICAL` Configuration block that defines the historical data that your auto-adjusting budget is based on.
     */
    @JvmName("unmcequkmkkglakm")
    public suspend fun historicalOptions(argument: suspend BudgetAutoAdjustDataHistoricalOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = BudgetAutoAdjustDataHistoricalOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.historicalOptions = mapped
    }

    /**
     * @param value (Optional) - The last time that your budget was auto-adjusted.
     */
    @JvmName("ipfgpivxpjqvlsti")
    public suspend fun lastAutoAdjustTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastAutoAdjustTime = mapped
    }

    internal fun build(): BudgetAutoAdjustDataArgs = BudgetAutoAdjustDataArgs(
        autoAdjustType = autoAdjustType ?: throw PulumiNullFieldException("autoAdjustType"),
        historicalOptions = historicalOptions,
        lastAutoAdjustTime = lastAutoAdjustTime,
    )
}
