@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.inputs

import com.pulumi.aws.budgets.inputs.BudgetCostFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of a budget. Unique within accounts.
 * @property values
 */
public data class BudgetCostFilterArgs(
    public val name: Output<String>,
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.budgets.inputs.BudgetCostFilterArgs> {
    override fun toJava(): com.pulumi.aws.budgets.inputs.BudgetCostFilterArgs =
        com.pulumi.aws.budgets.inputs.BudgetCostFilterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [BudgetCostFilterArgs].
 */
@PulumiTagMarker
public class BudgetCostFilterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value The name of a budget. Unique within accounts.
     */
    @JvmName("wrplvywxvfwfuwau")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("ahweiastvqjpjycy")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("wiyoejvwhsoqhsuy")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("tlepforydfkukhng")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The name of a budget. Unique within accounts.
     */
    @JvmName("mxadchudrobqkuxf")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("jabbeoaufuxrurdw")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values
     */
    @JvmName("ecwodsspitulvalj")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): BudgetCostFilterArgs = BudgetCostFilterArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
