@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.inputs

import com.pulumi.aws.budgets.inputs.BudgetPlannedLimitArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property amount (Required) The amount of cost or usage being measured for a budget.
 * @property startTime (Required) The start time of the budget limit. Format: `2017-01-01_12:00`. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
 * @property unit (Required) The unit of measurement used for the budget forecast, actual spend, or budget threshold, such as dollars or GB. See [Spend](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/data-type-spend.html) documentation.
 */
public data class BudgetPlannedLimitArgs(
    public val amount: Output<String>,
    public val startTime: Output<String>,
    public val unit: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.budgets.inputs.BudgetPlannedLimitArgs> {
    override fun toJava(): com.pulumi.aws.budgets.inputs.BudgetPlannedLimitArgs =
        com.pulumi.aws.budgets.inputs.BudgetPlannedLimitArgs.builder()
            .amount(amount.applyValue({ args0 -> args0 }))
            .startTime(startTime.applyValue({ args0 -> args0 }))
            .unit(unit.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BudgetPlannedLimitArgs].
 */
@PulumiTagMarker
public class BudgetPlannedLimitArgsBuilder internal constructor() {
    private var amount: Output<String>? = null

    private var startTime: Output<String>? = null

    private var unit: Output<String>? = null

    /**
     * @param value (Required) The amount of cost or usage being measured for a budget.
     */
    @JvmName("unndkksvsjvcmhgl")
    public suspend fun amount(`value`: Output<String>) {
        this.amount = value
    }

    /**
     * @param value (Required) The start time of the budget limit. Format: `2017-01-01_12:00`. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
     */
    @JvmName("pitmqqbsplftamgn")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value (Required) The unit of measurement used for the budget forecast, actual spend, or budget threshold, such as dollars or GB. See [Spend](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/data-type-spend.html) documentation.
     */
    @JvmName("ytnkyurnwacqenut")
    public suspend fun unit(`value`: Output<String>) {
        this.unit = value
    }

    /**
     * @param value (Required) The amount of cost or usage being measured for a budget.
     */
    @JvmName("hkqxmetquikpllpp")
    public suspend fun amount(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.amount = mapped
    }

    /**
     * @param value (Required) The start time of the budget limit. Format: `2017-01-01_12:00`. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
     */
    @JvmName("rahwjpxvxliiophe")
    public suspend fun startTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value (Required) The unit of measurement used for the budget forecast, actual spend, or budget threshold, such as dollars or GB. See [Spend](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/data-type-spend.html) documentation.
     */
    @JvmName("itswfanvulqkjwnc")
    public suspend fun unit(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.unit = mapped
    }

    internal fun build(): BudgetPlannedLimitArgs = BudgetPlannedLimitArgs(
        amount = amount ?: throw PulumiNullFieldException("amount"),
        startTime = startTime ?: throw PulumiNullFieldException("startTime"),
        unit = unit ?: throw PulumiNullFieldException("unit"),
    )
}
