@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.inputs

import com.pulumi.aws.budgets.inputs.GetBudgetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBudget.
 * @property accountId The ID of the target account for budget. Will use current user's account_id by default if omitted.
 * @property name The name of a budget. Unique within accounts.
 * The following arguments are optional:
 * @property namePrefix The prefix of the name of a budget. Unique within accounts.
 * @property tags Map of tags assigned to the resource.
 */
public data class GetBudgetPlainArgs(
    public val accountId: String? = null,
    public val name: String,
    public val namePrefix: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.budgets.inputs.GetBudgetPlainArgs> {
    override fun toJava(): com.pulumi.aws.budgets.inputs.GetBudgetPlainArgs =
        com.pulumi.aws.budgets.inputs.GetBudgetPlainArgs.builder()
            .accountId(accountId?.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .namePrefix(namePrefix?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetBudgetPlainArgs].
 */
@PulumiTagMarker
public class GetBudgetPlainArgsBuilder internal constructor() {
    private var accountId: String? = null

    private var name: String? = null

    private var namePrefix: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value The ID of the target account for budget. Will use current user's account_id by default if omitted.
     */
    @JvmName("chpquebolvsxehle")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.accountId = mapped
    }

    /**
     * @param value The name of a budget. Unique within accounts.
     * The following arguments are optional:
     */
    @JvmName("lifsrxrfnseqmbqe")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The prefix of the name of a budget. Unique within accounts.
     */
    @JvmName("bshwshwltfovumsk")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.namePrefix = mapped
    }

    /**
     * @param value Map of tags assigned to the resource.
     */
    @JvmName("vhkhutlxwewfxugk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the resource.
     */
    @JvmName("efxkrcxmocdjiuqw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetBudgetPlainArgs = GetBudgetPlainArgs(
        accountId = accountId,
        name = name ?: throw PulumiNullFieldException("name"),
        namePrefix = namePrefix,
        tags = tags,
    )
}
