@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property actionThresholdType The type of threshold for a notification. Valid values are `PERCENTAGE` or `ABSOLUTE_VALUE`.
 * @property actionThresholdValue The threshold of a notification.
 */
public data class BudgetActionActionThreshold(
    public val actionThresholdType: String,
    public val actionThresholdValue: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.budgets.outputs.BudgetActionActionThreshold): BudgetActionActionThreshold = BudgetActionActionThreshold(
            actionThresholdType = javaType.actionThresholdType(),
            actionThresholdValue = javaType.actionThresholdValue(),
        )
    }
}
