@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property iamActionDefinition The AWS Identity and Access Management (IAM) action definition details. See IAM Action Definition.
 * @property scpActionDefinition The service control policies (SCPs) action definition details. See SCP Action Definition.
 * @property ssmActionDefinition The AWS Systems Manager (SSM) action definition details. See SSM Action Definition.
 */
public data class BudgetActionDefinition(
    public val iamActionDefinition: BudgetActionDefinitionIamActionDefinition? = null,
    public val scpActionDefinition: BudgetActionDefinitionScpActionDefinition? = null,
    public val ssmActionDefinition: BudgetActionDefinitionSsmActionDefinition? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.budgets.outputs.BudgetActionDefinition): BudgetActionDefinition = BudgetActionDefinition(
            iamActionDefinition = javaType.iamActionDefinition().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.budgets.kotlin.outputs.BudgetActionDefinitionIamActionDefinition.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scpActionDefinition = javaType.scpActionDefinition().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.budgets.kotlin.outputs.BudgetActionDefinitionScpActionDefinition.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ssmActionDefinition = javaType.ssmActionDefinition().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.budgets.kotlin.outputs.BudgetActionDefinitionSsmActionDefinition.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
