@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property amount (Required) The amount of cost or usage being measured for a budget.
 * @property startTime (Required) The start time of the budget limit. Format: `2017-01-01_12:00`. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
 * @property unit (Required) The unit of measurement used for the budget forecast, actual spend, or budget threshold, such as dollars or GB. See [Spend](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/data-type-spend.html) documentation.
 */
public data class BudgetPlannedLimit(
    public val amount: String,
    public val startTime: String,
    public val unit: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.budgets.outputs.BudgetPlannedLimit): BudgetPlannedLimit = BudgetPlannedLimit(
            amount = javaType.amount(),
            startTime = javaType.startTime(),
            unit = javaType.unit(),
        )
    }
}
