@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property budgetAdjustmentPeriod (Required) - The number of budget periods included in the moving-average calculation that determines your auto-adjusted budget amount.
 * @property lookbackAvailablePeriods (Optional) - The integer that describes how many budget periods in your BudgetAdjustmentPeriod are included in the calculation of your current budget limit. If the first budget period in your BudgetAdjustmentPeriod has no cost data, then that budget period isn’t included in the average that determines your budget limit. You can’t set your own LookBackAvailablePeriods. The value is automatically calculated from the `budget_adjustment_period` and your historical cost data.
 */
public data class GetBudgetAutoAdjustDataHistoricalOption(
    public val budgetAdjustmentPeriod: Int,
    public val lookbackAvailablePeriods: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.budgets.outputs.GetBudgetAutoAdjustDataHistoricalOption): GetBudgetAutoAdjustDataHistoricalOption = GetBudgetAutoAdjustDataHistoricalOption(
            budgetAdjustmentPeriod = javaType.budgetAdjustmentPeriod(),
            lookbackAvailablePeriods = javaType.lookbackAvailablePeriods(),
        )
    }
}
