@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property amount The cost or usage amount that's associated with a budget forecast, actual spend, or budget threshold. Length Constraints: Minimum length of `1`. Maximum length of `2147483647`.
 * @property startTime (Required) The start time of the budget limit. Format: `2017-01-01_12:00`. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
 * @property unit The unit of measurement that's used for the budget forecast, actual spend, or budget threshold, such as USD or GBP. Length Constraints: Minimum length of `1`. Maximum length of `2147483647`.
 */
public data class GetBudgetPlannedLimit(
    public val amount: String,
    public val startTime: String,
    public val unit: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.budgets.outputs.GetBudgetPlannedLimit): GetBudgetPlannedLimit = GetBudgetPlannedLimit(
            amount = javaType.amount(),
            startTime = javaType.startTime(),
            unit = javaType.unit(),
        )
    }
}
