@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getBudget.
 * @property accountId
 * @property arn
 * @property autoAdjustDatas Object containing [AutoAdjustData] which determines the budget amount for an auto-adjusting budget.
 * @property budgetExceeded Boolean indicating whether this budget has been exceeded.
 * @property budgetLimits The total amount of cost, usage, RI utilization, RI coverage, Savings Plans utilization, or Savings Plans coverage that you want to track with your budget. Contains object Spend.
 * @property budgetType Whether this budget tracks monetary cost or usage.
 * @property calculatedSpends The spend objects that are associated with this budget. The actualSpend tracks how much you've used, cost, usage, RI units, or Savings Plans units and the forecastedSpend tracks how much that you're predicted to spend based on your historical usage profile.
 * @property costFilters A list of CostFilter name/values pair to apply to budget.
 * @property costTypes Object containing CostTypes The types of cost included in a budget, such as tax and subscriptions.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property namePrefix
 * @property notifications Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
 * @property plannedLimits Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
 * @property tags Map of tags assigned to the resource.
 * @property timePeriodEnd The end of the time period covered by the budget. There are no restrictions on the end date. Format: `2017-01-01_12:00`.
 * @property timePeriodStart The start of the time period covered by the budget. If you don't specify a start date, AWS defaults to the start of your chosen time period. The start date must come before the end date. Format: `2017-01-01_12:00`.
 * @property timeUnit The length of time until a budget resets the actual and forecasted spend. Valid values: `MONTHLY`, `QUARTERLY`, `ANNUALLY`, and `DAILY`.
 */
public data class GetBudgetResult(
    public val accountId: String,
    public val arn: String,
    public val autoAdjustDatas: List<GetBudgetAutoAdjustData>,
    public val budgetExceeded: Boolean,
    public val budgetLimits: List<GetBudgetBudgetLimit>,
    public val budgetType: String,
    public val calculatedSpends: List<GetBudgetCalculatedSpend>,
    public val costFilters: List<GetBudgetCostFilter>,
    public val costTypes: List<GetBudgetCostType>,
    public val id: String,
    public val name: String,
    public val namePrefix: String? = null,
    public val notifications: List<GetBudgetNotification>,
    public val plannedLimits: List<GetBudgetPlannedLimit>,
    public val tags: Map<String, String>,
    public val timePeriodEnd: String,
    public val timePeriodStart: String,
    public val timeUnit: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.budgets.outputs.GetBudgetResult): GetBudgetResult =
            GetBudgetResult(
                accountId = javaType.accountId(),
                arn = javaType.arn(),
                autoAdjustDatas = javaType.autoAdjustDatas().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.budgets.kotlin.outputs.GetBudgetAutoAdjustData.Companion.toKotlin(args0)
                    })
                }),
                budgetExceeded = javaType.budgetExceeded(),
                budgetLimits = javaType.budgetLimits().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.budgets.kotlin.outputs.GetBudgetBudgetLimit.Companion.toKotlin(args0)
                    })
                }),
                budgetType = javaType.budgetType(),
                calculatedSpends = javaType.calculatedSpends().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.budgets.kotlin.outputs.GetBudgetCalculatedSpend.Companion.toKotlin(args0)
                    })
                }),
                costFilters = javaType.costFilters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.budgets.kotlin.outputs.GetBudgetCostFilter.Companion.toKotlin(args0)
                    })
                }),
                costTypes = javaType.costTypes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.budgets.kotlin.outputs.GetBudgetCostType.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                name = javaType.name(),
                namePrefix = javaType.namePrefix().map({ args0 -> args0 }).orElse(null),
                notifications = javaType.notifications().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.budgets.kotlin.outputs.GetBudgetNotification.Companion.toKotlin(args0)
                    })
                }),
                plannedLimits = javaType.plannedLimits().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.budgets.kotlin.outputs.GetBudgetPlannedLimit.Companion.toKotlin(args0)
                    })
                }),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                timePeriodEnd = javaType.timePeriodEnd(),
                timePeriodStart = javaType.timePeriodStart(),
                timeUnit = javaType.timeUnit(),
            )
    }
}
