@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.aws.cfg.ConformancePackArgs.builder
import com.pulumi.aws.cfg.kotlin.inputs.ConformancePackInputParameterArgs
import com.pulumi.aws.cfg.kotlin.inputs.ConformancePackInputParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages a Config Conformance Pack. More information about this collection of Config rules and remediation actions can be found in the
 * [Conformance Packs](https://docs.aws.amazon.com/config/latest/developerguide/conformance-packs.html) documentation.
 * Sample Conformance Pack templates may be found in the
 * [AWS Config Rules Repository](https://github.com/awslabs/aws-config-rules/tree/master/aws-config-conformance-packs).
 * > **NOTE:** The account must have a Configuration Recorder with proper IAM permissions before the Conformance Pack will
 * successfully create or update. See also the
 * `aws.cfg.Recorder` resource.
 * ## Example Usage
 * ### Template Body
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cfg.ConformancePack("example", {
 *     name: "example",
 *     inputParameters: [{
 *         parameterName: "AccessKeysRotatedParameterMaxAccessKeyAge",
 *         parameterValue: "90",
 *     }],
 *     templateBody: `Parameters:
 *   AccessKeysRotatedParameterMaxAccessKeyAge:
 *     Type: String
 * Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 * `,
 * }, {
 *     dependsOn: [exampleAwsConfigConfigurationRecorder],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cfg.ConformancePack("example",
 *     name="example",
 *     input_parameters=[{
 *         "parameter_name": "AccessKeysRotatedParameterMaxAccessKeyAge",
 *         "parameter_value": "90",
 *     }],
 *     template_body="""Parameters:
 *   AccessKeysRotatedParameterMaxAccessKeyAge:
 *     Type: String
 * Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 * """,
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_config_configuration_recorder]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Cfg.ConformancePack("example", new()
 *     {
 *         Name = "example",
 *         InputParameters = new[]
 *         {
 *             new Aws.Cfg.Inputs.ConformancePackInputParameterArgs
 *             {
 *                 ParameterName = "AccessKeysRotatedParameterMaxAccessKeyAge",
 *                 ParameterValue = "90",
 *             },
 *         },
 *         TemplateBody = @"Parameters:
 *   AccessKeysRotatedParameterMaxAccessKeyAge:
 *     Type: String
 * Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 * ",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsConfigConfigurationRecorder,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cfg"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cfg.NewConformancePack(ctx, "example", &cfg.ConformancePackArgs{
 * 			Name: pulumi.String("example"),
 * 			InputParameters: cfg.ConformancePackInputParameterArray{
 * 				&cfg.ConformancePackInputParameterArgs{
 * 					ParameterName:  pulumi.String("AccessKeysRotatedParameterMaxAccessKeyAge"),
 * 					ParameterValue: pulumi.String("90"),
 * 				},
 * 			},
 * 			TemplateBody: pulumi.String(`Parameters:
 *   AccessKeysRotatedParameterMaxAccessKeyAge:
 *     Type: String
 * Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 * `),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsConfigConfigurationRecorder,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cfg.ConformancePack;
 * import com.pulumi.aws.cfg.ConformancePackArgs;
 * import com.pulumi.aws.cfg.inputs.ConformancePackInputParameterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ConformancePack("example", ConformancePackArgs.builder()
 *             .name("example")
 *             .inputParameters(ConformancePackInputParameterArgs.builder()
 *                 .parameterName("AccessKeysRotatedParameterMaxAccessKeyAge")
 *                 .parameterValue("90")
 *                 .build())
 *             .templateBody("""
 * Parameters:
 *   AccessKeysRotatedParameterMaxAccessKeyAge:
 *     Type: String
 * Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 *             """)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsConfigConfigurationRecorder)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cfg:ConformancePack
 *     properties:
 *       name: example
 *       inputParameters:
 *         - parameterName: AccessKeysRotatedParameterMaxAccessKeyAge
 *           parameterValue: '90'
 *       templateBody: |
 *         Parameters:
 *           AccessKeysRotatedParameterMaxAccessKeyAge:
 *             Type: String
 *         Resources:
 *           IAMPasswordPolicy:
 *             Properties:
 *               ConfigRuleName: IAMPasswordPolicy
 *               Source:
 *                 Owner: AWS
 *                 SourceIdentifier: IAM_PASSWORD_POLICY
 *             Type: AWS::Config::ConfigRule
 *     options:
 *       dependson:
 *         - ${exampleAwsConfigConfigurationRecorder}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Template S3 URI
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleBucketV2 = new aws.s3.BucketV2("example", {bucket: "example"});
 * const exampleBucketObjectv2 = new aws.s3.BucketObjectv2("example", {
 *     bucket: exampleBucketV2.id,
 *     key: "example-key",
 *     content: `Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 * `,
 * });
 * const example = new aws.cfg.ConformancePack("example", {
 *     name: "example",
 *     templateS3Uri: pulumi.interpolate`s3://${exampleBucketV2.bucket}/${exampleBucketObjectv2.key}`,
 * }, {
 *     dependsOn: [exampleAwsConfigConfigurationRecorder],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_bucket_v2 = aws.s3.BucketV2("example", bucket="example")
 * example_bucket_objectv2 = aws.s3.BucketObjectv2("example",
 *     bucket=example_bucket_v2.id,
 *     key="example-key",
 *     content="""Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 * """)
 * example = aws.cfg.ConformancePack("example",
 *     name="example",
 *     template_s3_uri=pulumi.Output.all(example_bucket_v2.bucket, example_bucket_objectv2.key).apply(lambda bucket, key: f"s3://{bucket}/{key}"),
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_config_configuration_recorder]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleBucketV2 = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example",
 *     });
 *     var exampleBucketObjectv2 = new Aws.S3.BucketObjectv2("example", new()
 *     {
 *         Bucket = exampleBucketV2.Id,
 *         Key = "example-key",
 *         Content = @"Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 * ",
 *     });
 *     var example = new Aws.Cfg.ConformancePack("example", new()
 *     {
 *         Name = "example",
 *         TemplateS3Uri = Output.Tuple(exampleBucketV2.Bucket, exampleBucketObjectv2.Key).Apply(values =>
 *         {
 *             var bucket = values.Item1;
 *             var key = values.Item2;
 *             return $"s3://{bucket}/{key}";
 *         }),
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsConfigConfigurationRecorder,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cfg"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleBucketV2, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleBucketObjectv2, err := s3.NewBucketObjectv2(ctx, "example", &s3.BucketObjectv2Args{
 * 			Bucket: exampleBucketV2.ID(),
 * 			Key:    pulumi.String("example-key"),
 * 			Content: pulumi.String(`Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cfg.NewConformancePack(ctx, "example", &cfg.ConformancePackArgs{
 * 			Name: pulumi.String("example"),
 * 			TemplateS3Uri: pulumi.All(exampleBucketV2.Bucket, exampleBucketObjectv2.Key).ApplyT(func(_args []interface{}) (string, error) {
 * 				bucket := _args[0].(string)
 * 				key := _args[1].(string)
 * 				return fmt.Sprintf("s3://%v/%v", bucket, key), nil
 * 			}).(pulumi.StringOutput),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsConfigConfigurationRecorder,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.cfg.ConformancePack;
 * import com.pulumi.aws.cfg.ConformancePackArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .bucket("example")
 *             .build());
 *         var exampleBucketObjectv2 = new BucketObjectv2("exampleBucketObjectv2", BucketObjectv2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .key("example-key")
 *             .content("""
 * Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 *             """)
 *             .build());
 *         var example = new ConformancePack("example", ConformancePackArgs.builder()
 *             .name("example")
 *             .templateS3Uri(Output.tuple(exampleBucketV2.bucket(), exampleBucketObjectv2.key()).applyValue(values -> {
 *                 var bucket = values.t1;
 *                 var key = values.t2;
 *                 return String.format("s3://%s/%s", bucket,key);
 *             }))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsConfigConfigurationRecorder)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cfg:ConformancePack
 *     properties:
 *       name: example
 *       templateS3Uri: s3://${exampleBucketV2.bucket}/${exampleBucketObjectv2.key}
 *     options:
 *       dependson:
 *         - ${exampleAwsConfigConfigurationRecorder}
 *   exampleBucketV2:
 *     type: aws:s3:BucketV2
 *     name: example
 *     properties:
 *       bucket: example
 *   exampleBucketObjectv2:
 *     type: aws:s3:BucketObjectv2
 *     name: example
 *     properties:
 *       bucket: ${exampleBucketV2.id}
 *       key: example-key
 *       content: |
 *         Resources:
 *           IAMPasswordPolicy:
 *             Properties:
 *               ConfigRuleName: IAMPasswordPolicy
 *               Source:
 *                 Owner: AWS
 *                 SourceIdentifier: IAM_PASSWORD_POLICY
 *             Type: AWS::Config::ConfigRule
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Config Conformance Packs using the `name`. For example:
 * ```sh
 * $ pulumi import aws:cfg/conformancePack:ConformancePack example example
 * ```
 * @property deliveryS3Bucket Amazon S3 bucket where AWS Config stores conformance pack templates. Maximum length of 63.
 * @property deliveryS3KeyPrefix The prefix for the Amazon S3 bucket. Maximum length of 1024.
 * @property inputParameters Set of configuration blocks describing input parameters passed to the conformance pack template. Documented below. When configured, the parameters must also be included in the `template_body` or in the template stored in Amazon S3 if using `template_s3_uri`.
 * @property name The name of the conformance pack. Must begin with a letter and contain from 1 to 256 alphanumeric characters and hyphens.
 * @property templateBody A string containing full conformance pack template body. Maximum length of 51200. Drift detection is not possible with this argument.
 * @property templateS3Uri Location of file, e.g., `s3://bucketname/prefix`, containing the template body. The uri must point to the conformance pack template that is located in an Amazon S3 bucket in the same region as the conformance pack. Maximum length of 1024. Drift detection is not possible with this argument.
 */
public data class ConformancePackArgs(
    public val deliveryS3Bucket: Output<String>? = null,
    public val deliveryS3KeyPrefix: Output<String>? = null,
    public val inputParameters: Output<List<ConformancePackInputParameterArgs>>? = null,
    public val name: Output<String>? = null,
    public val templateBody: Output<String>? = null,
    public val templateS3Uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.ConformancePackArgs> {
    override fun toJava(): com.pulumi.aws.cfg.ConformancePackArgs =
        com.pulumi.aws.cfg.ConformancePackArgs.builder()
            .deliveryS3Bucket(deliveryS3Bucket?.applyValue({ args0 -> args0 }))
            .deliveryS3KeyPrefix(deliveryS3KeyPrefix?.applyValue({ args0 -> args0 }))
            .inputParameters(
                inputParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .templateBody(templateBody?.applyValue({ args0 -> args0 }))
            .templateS3Uri(templateS3Uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConformancePackArgs].
 */
@PulumiTagMarker
public class ConformancePackArgsBuilder internal constructor() {
    private var deliveryS3Bucket: Output<String>? = null

    private var deliveryS3KeyPrefix: Output<String>? = null

    private var inputParameters: Output<List<ConformancePackInputParameterArgs>>? = null

    private var name: Output<String>? = null

    private var templateBody: Output<String>? = null

    private var templateS3Uri: Output<String>? = null

    /**
     * @param value Amazon S3 bucket where AWS Config stores conformance pack templates. Maximum length of 63.
     */
    @JvmName("fqmvrsgpgmituyho")
    public suspend fun deliveryS3Bucket(`value`: Output<String>) {
        this.deliveryS3Bucket = value
    }

    /**
     * @param value The prefix for the Amazon S3 bucket. Maximum length of 1024.
     */
    @JvmName("xnjqeifaxgfgwiys")
    public suspend fun deliveryS3KeyPrefix(`value`: Output<String>) {
        this.deliveryS3KeyPrefix = value
    }

    /**
     * @param value Set of configuration blocks describing input parameters passed to the conformance pack template. Documented below. When configured, the parameters must also be included in the `template_body` or in the template stored in Amazon S3 if using `template_s3_uri`.
     */
    @JvmName("djieqqyjdxlrodcd")
    public suspend fun inputParameters(`value`: Output<List<ConformancePackInputParameterArgs>>) {
        this.inputParameters = value
    }

    @JvmName("yulmsijmukisivnx")
    public suspend fun inputParameters(vararg values: Output<ConformancePackInputParameterArgs>) {
        this.inputParameters = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks describing input parameters passed to the conformance pack template. Documented below. When configured, the parameters must also be included in the `template_body` or in the template stored in Amazon S3 if using `template_s3_uri`.
     */
    @JvmName("dnstwiefqqkkvtuo")
    public suspend fun inputParameters(values: List<Output<ConformancePackInputParameterArgs>>) {
        this.inputParameters = Output.all(values)
    }

    /**
     * @param value The name of the conformance pack. Must begin with a letter and contain from 1 to 256 alphanumeric characters and hyphens.
     */
    @JvmName("gejsxbhevclgqrcb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A string containing full conformance pack template body. Maximum length of 51200. Drift detection is not possible with this argument.
     */
    @JvmName("tqbiikjdrtyqsyem")
    public suspend fun templateBody(`value`: Output<String>) {
        this.templateBody = value
    }

    /**
     * @param value Location of file, e.g., `s3://bucketname/prefix`, containing the template body. The uri must point to the conformance pack template that is located in an Amazon S3 bucket in the same region as the conformance pack. Maximum length of 1024. Drift detection is not possible with this argument.
     */
    @JvmName("ghwypwjwberxpasq")
    public suspend fun templateS3Uri(`value`: Output<String>) {
        this.templateS3Uri = value
    }

    /**
     * @param value Amazon S3 bucket where AWS Config stores conformance pack templates. Maximum length of 63.
     */
    @JvmName("fghaxkkpuknxvmiy")
    public suspend fun deliveryS3Bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryS3Bucket = mapped
    }

    /**
     * @param value The prefix for the Amazon S3 bucket. Maximum length of 1024.
     */
    @JvmName("svxispyrvshrfgji")
    public suspend fun deliveryS3KeyPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryS3KeyPrefix = mapped
    }

    /**
     * @param value Set of configuration blocks describing input parameters passed to the conformance pack template. Documented below. When configured, the parameters must also be included in the `template_body` or in the template stored in Amazon S3 if using `template_s3_uri`.
     */
    @JvmName("vvclcydoiibyacwu")
    public suspend fun inputParameters(`value`: List<ConformancePackInputParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputParameters = mapped
    }

    /**
     * @param argument Set of configuration blocks describing input parameters passed to the conformance pack template. Documented below. When configured, the parameters must also be included in the `template_body` or in the template stored in Amazon S3 if using `template_s3_uri`.
     */
    @JvmName("kmvhrnnqtumagssi")
    public suspend fun inputParameters(argument: List<suspend ConformancePackInputParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConformancePackInputParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inputParameters = mapped
    }

    /**
     * @param argument Set of configuration blocks describing input parameters passed to the conformance pack template. Documented below. When configured, the parameters must also be included in the `template_body` or in the template stored in Amazon S3 if using `template_s3_uri`.
     */
    @JvmName("mmhcqvxjgwmcvuae")
    public suspend fun inputParameters(vararg argument: suspend ConformancePackInputParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ConformancePackInputParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inputParameters = mapped
    }

    /**
     * @param argument Set of configuration blocks describing input parameters passed to the conformance pack template. Documented below. When configured, the parameters must also be included in the `template_body` or in the template stored in Amazon S3 if using `template_s3_uri`.
     */
    @JvmName("xgkvcamfuvtekljr")
    public suspend fun inputParameters(argument: suspend ConformancePackInputParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ConformancePackInputParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.inputParameters = mapped
    }

    /**
     * @param values Set of configuration blocks describing input parameters passed to the conformance pack template. Documented below. When configured, the parameters must also be included in the `template_body` or in the template stored in Amazon S3 if using `template_s3_uri`.
     */
    @JvmName("xqcaosuldrvafmuu")
    public suspend fun inputParameters(vararg values: ConformancePackInputParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputParameters = mapped
    }

    /**
     * @param value The name of the conformance pack. Must begin with a letter and contain from 1 to 256 alphanumeric characters and hyphens.
     */
    @JvmName("rrjxbqewjivsnymg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A string containing full conformance pack template body. Maximum length of 51200. Drift detection is not possible with this argument.
     */
    @JvmName("nehpjjffxhbqwoan")
    public suspend fun templateBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateBody = mapped
    }

    /**
     * @param value Location of file, e.g., `s3://bucketname/prefix`, containing the template body. The uri must point to the conformance pack template that is located in an Amazon S3 bucket in the same region as the conformance pack. Maximum length of 1024. Drift detection is not possible with this argument.
     */
    @JvmName("lxrstbqlpvkvjeri")
    public suspend fun templateS3Uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateS3Uri = mapped
    }

    internal fun build(): ConformancePackArgs = ConformancePackArgs(
        deliveryS3Bucket = deliveryS3Bucket,
        deliveryS3KeyPrefix = deliveryS3KeyPrefix,
        inputParameters = inputParameters,
        name = name,
        templateBody = templateBody,
        templateS3Uri = templateS3Uri,
    )
}
