@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.aws.cfg.kotlin.outputs.DeliveryChannelSnapshotDeliveryProperties
import com.pulumi.aws.cfg.kotlin.outputs.DeliveryChannelSnapshotDeliveryProperties.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DeliveryChannel].
 */
@PulumiTagMarker
public class DeliveryChannelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeliveryChannelArgs = DeliveryChannelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeliveryChannelArgsBuilder.() -> Unit) {
        val builder = DeliveryChannelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DeliveryChannel {
        val builtJavaResource = com.pulumi.aws.cfg.DeliveryChannel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DeliveryChannel(builtJavaResource)
    }
}

/**
 * Provides an AWS Config Delivery Channel.
 * > **Note:** Delivery Channel requires a Configuration Recorder to be present. Use of `depends_on` (as shown below) is recommended to avoid race conditions.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const b = new aws.s3.BucketV2("b", {
 *     bucket: "example-awsconfig",
 *     forceDestroy: true,
 * });
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["config&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const r = new aws.iam.Role("r", {
 *     name: "awsconfig-example",
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 * });
 * const fooRecorder = new aws.cfg.Recorder("foo", {
 *     name: "example",
 *     roleArn: r.arn,
 * });
 * const foo = new aws.cfg.DeliveryChannel("foo", {
 *     name: "example",
 *     s3BucketName: b.bucket,
 * }, {
 *     dependsOn: [fooRecorder],
 * });
 * const p = aws.iam.getPolicyDocumentOutput({
 *     statements: [{
 *         effect: "Allow",
 *         actions: ["s3:*"],
 *         resources: [
 *             b.arn,
 *             pulumi.interpolate`${b.arn}/*`,
 *         ],
 *     }],
 * });
 * const pRolePolicy = new aws.iam.RolePolicy("p", {
 *     name: "awsconfig-example",
 *     role: r.id,
 *     policy: p.apply(p => p.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * b = aws.s3.BucketV2("b",
 *     bucket="example-awsconfig",
 *     force_destroy=True)
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["config&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * r = aws.iam.Role("r",
 *     name="awsconfig-example",
 *     assume_role_policy=assume_role.json)
 * foo_recorder = aws.cfg.Recorder("foo",
 *     name="example",
 *     role_arn=r.arn)
 * foo = aws.cfg.DeliveryChannel("foo",
 *     name="example",
 *     s3_bucket_name=b.bucket,
 *     opts = pulumi.ResourceOptions(depends_on=[foo_recorder]))
 * p = aws.iam.get_policy_document_output(statements=[{
 *     "effect": "Allow",
 *     "actions": ["s3:*"],
 *     "resources": [
 *         b.arn,
 *         b.arn.apply(lambda arn: f"{arn}/*"),
 *     ],
 * }])
 * p_role_policy = aws.iam.RolePolicy("p",
 *     name="awsconfig-example",
 *     role=r.id,
 *     policy=p.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var b = new Aws.S3.BucketV2("b", new()
 *     {
 *         Bucket = "example-awsconfig",
 *         ForceDestroy = true,
 *     });
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "config.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var r = new Aws.Iam.Role("r", new()
 *     {
 *         Name = "awsconfig-example",
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var fooRecorder = new Aws.Cfg.Recorder("foo", new()
 *     {
 *         Name = "example",
 *         RoleArn = r.Arn,
 *     });
 *     var foo = new Aws.Cfg.DeliveryChannel("foo", new()
 *     {
 *         Name = "example",
 *         S3BucketName = b.Bucket,
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             fooRecorder,
 *         },
 *     });
 *     var p = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "s3:*",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     b.Arn,
 *                     $"{b.Arn}/*",
 *                 },
 *             },
 *         },
 *     });
 *     var pRolePolicy = new Aws.Iam.RolePolicy("p", new()
 *     {
 *         Name = "awsconfig-example",
 *         Role = r.Id,
 *         Policy = p.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cfg"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		b, err := s3.NewBucketV2(ctx, "b", &s3.BucketV2Args{
 * 			Bucket:       pulumi.String("example-awsconfig"),
 * 			ForceDestroy: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"config.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		r, err := iam.NewRole(ctx, "r", &iam.RoleArgs{
 * 			Name:             pulumi.String("awsconfig-example"),
 * 			AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		fooRecorder, err := cfg.NewRecorder(ctx, "foo", &cfg.RecorderArgs{
 * 			Name:    pulumi.String("example"),
 * 			RoleArn: r.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cfg.NewDeliveryChannel(ctx, "foo", &cfg.DeliveryChannelArgs{
 * 			Name:         pulumi.String("example"),
 * 			S3BucketName: b.Bucket,
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			fooRecorder,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		p := iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * 			Statements: iam.GetPolicyDocumentStatementArray{
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Effect: pulumi.String("Allow"),
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("s3:*"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						b.Arn,
 * 						b.Arn.ApplyT(func(arn string) (string, error) {
 * 							return fmt.Sprintf("%v/*", arn), nil
 * 						}).(pulumi.StringOutput),
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		_, err = iam.NewRolePolicy(ctx, "p", &iam.RolePolicyArgs{
 * 			Name: pulumi.String("awsconfig-example"),
 * 			Role: r.ID(),
 * 			Policy: pulumi.String(p.ApplyT(func(p iam.GetPolicyDocumentResult) (*string, error) {
 * 				return &p.Json, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.cfg.Recorder;
 * import com.pulumi.aws.cfg.RecorderArgs;
 * import com.pulumi.aws.cfg.DeliveryChannel;
 * import com.pulumi.aws.cfg.DeliveryChannelArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var b = new BucketV2("b", BucketV2Args.builder()
 *             .bucket("example-awsconfig")
 *             .forceDestroy(true)
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("config.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var r = new Role("r", RoleArgs.builder()
 *             .name("awsconfig-example")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var fooRecorder = new Recorder("fooRecorder", RecorderArgs.builder()
 *             .name("example")
 *             .roleArn(r.arn())
 *             .build());
 *         var foo = new DeliveryChannel("foo", DeliveryChannelArgs.builder()
 *             .name("example")
 *             .s3BucketName(b.bucket())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(fooRecorder)
 *                 .build());
 *         final var p = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("s3:*")
 *                 .resources(
 *                     b.arn(),
 *                     b.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                 .build())
 *             .build());
 *         var pRolePolicy = new RolePolicy("pRolePolicy", RolePolicyArgs.builder()
 *             .name("awsconfig-example")
 *             .role(r.id())
 *             .policy(p.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(p -> p.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:cfg:DeliveryChannel
 *     properties:
 *       name: example
 *       s3BucketName: ${b.bucket}
 *     options:
 *       dependson:
 *         - ${fooRecorder}
 *   b:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: example-awsconfig
 *       forceDestroy: true
 *   fooRecorder:
 *     type: aws:cfg:Recorder
 *     name: foo
 *     properties:
 *       name: example
 *       roleArn: ${r.arn}
 *   r:
 *     type: aws:iam:Role
 *     properties:
 *       name: awsconfig-example
 *       assumeRolePolicy: ${assumeRole.json}
 *   pRolePolicy:
 *     type: aws:iam:RolePolicy
 *     name: p
 *     properties:
 *       name: awsconfig-example
 *       role: ${r.id}
 *       policy: ${p.json}
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - config.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 *   p:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - s3:*
 *             resources:
 *               - ${b.arn}
 *               - ${b.arn}/*
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Delivery Channel using the name. For example:
 * ```sh
 * $ pulumi import aws:cfg/deliveryChannel:DeliveryChannel foo example
 * ```
 * */*/*/*/*/*/
 */
public class DeliveryChannel internal constructor(
    override val javaResource: com.pulumi.aws.cfg.DeliveryChannel,
) : KotlinCustomResource(javaResource, DeliveryChannelMapper) {
    /**
     * The name of the delivery channel. Defaults to `default`. Changing it recreates the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name of the S3 bucket used to store the configuration history.
     */
    public val s3BucketName: Output<String>
        get() = javaResource.s3BucketName().applyValue({ args0 -> args0 })

    /**
     * The prefix for the specified S3 bucket.
     */
    public val s3KeyPrefix: Output<String>?
        get() = javaResource.s3KeyPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the AWS KMS key used to encrypt objects delivered by AWS Config. Must belong to the same Region as the destination S3 bucket.
     */
    public val s3KmsKeyArn: Output<String>?
        get() = javaResource.s3KmsKeyArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Options for how AWS Config delivers configuration snapshots. See below
     */
    public val snapshotDeliveryProperties: Output<DeliveryChannelSnapshotDeliveryProperties>?
        get() = javaResource.snapshotDeliveryProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The ARN of the SNS topic that AWS Config delivers notifications to.
     */
    public val snsTopicArn: Output<String>?
        get() = javaResource.snsTopicArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object DeliveryChannelMapper : ResourceMapper<DeliveryChannel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cfg.DeliveryChannel::class == javaResource::class

    override fun map(javaResource: Resource): DeliveryChannel = DeliveryChannel(
        javaResource as
            com.pulumi.aws.cfg.DeliveryChannel,
    )
}

/**
 * @see [DeliveryChannel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DeliveryChannel].
 */
public suspend fun deliveryChannel(
    name: String,
    block: suspend DeliveryChannelResourceBuilder.() -> Unit,
): DeliveryChannel {
    val builder = DeliveryChannelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DeliveryChannel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deliveryChannel(name: String): DeliveryChannel {
    val builder = DeliveryChannelResourceBuilder()
    builder.name(name)
    return builder.build()
}
