@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.aws.cfg.kotlin.outputs.OrganizationConformancePackInputParameter
import com.pulumi.aws.cfg.kotlin.outputs.OrganizationConformancePackInputParameter.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [OrganizationConformancePack].
 */
@PulumiTagMarker
public class OrganizationConformancePackResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrganizationConformancePackArgs = OrganizationConformancePackArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrganizationConformancePackArgsBuilder.() -> Unit) {
        val builder = OrganizationConformancePackArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OrganizationConformancePack {
        val builtJavaResource = com.pulumi.aws.cfg.OrganizationConformancePack(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OrganizationConformancePack(builtJavaResource)
    }
}

/**
 * Manages a Config Organization Conformance Pack. More information can be found in the [Managing Conformance Packs Across all Accounts in Your Organization](https://docs&#46;aws&#46;amazon&#46;com/config/latest/developerguide/conformance-pack-organization-apis&#46;html) and [AWS Config Managed Rules](https://docs&#46;aws&#46;amazon&#46;com/config/latest/developerguide/evaluate-config_use-managed-rules&#46;html) documentation&#46; Example conformance pack templates may be found in the [AWS Config Rules Repository](https://github.com/awslabs/aws-config-rules/tree/master/aws-config-conformance-packs).
 * > **NOTE:** This resource must be created in the Organization master account or a delegated administrator account, and the Organization must have all features enabled. Every Organization account except those configured in the `excluded_accounts` argument must have a Configuration Recorder with proper IAM permissions before the Organization Conformance Pack will successfully create or update. See also the `aws.cfg.Recorder` resource.
 * ## Example Usage
 * ### Using Template Body
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleOrganization = new aws.organizations.Organization("example", {
 *     awsServiceAccessPrincipals: ["config-multiaccountsetup&#46;amazonaws&#46;com"],
 *     featureSet: "ALL",
 * });
 * const example = new aws.cfg.OrganizationConformancePack("example", {
 *     name: "example",
 *     inputParameters: [{
 *         parameterName: "AccessKeysRotatedParameterMaxAccessKeyAge",
 *         parameterValue: "90",
 *     }],
 *     templateBody: `Parameters:
 *   AccessKeysRotatedParameterMaxAccessKeyAge:
 *     Type: String
 * Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 * `,
 * }, {
 *     dependsOn: [
 *         exampleAwsConfigConfigurationRecorder,
 *         exampleOrganization,
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_organization = aws.organizations.Organization("example",
 *     aws_service_access_principals=["config-multiaccountsetup&#46;amazonaws&#46;com"],
 *     feature_set="ALL")
 * example = aws.cfg.OrganizationConformancePack("example",
 *     name="example",
 *     input_parameters=[{
 *         "parameter_name": "AccessKeysRotatedParameterMaxAccessKeyAge",
 *         "parameter_value": "90",
 *     }],
 *     template_body="""Parameters:
 *   AccessKeysRotatedParameterMaxAccessKeyAge:
 *     Type: String
 * Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 * """,
 *     opts = pulumi.ResourceOptions(depends_on=[
 *             example_aws_config_configuration_recorder,
 *             example_organization,
 *         ]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleOrganization = new Aws.Organizations.Organization("example", new()
 *     {
 *         AwsServiceAccessPrincipals = new[]
 *         {
 *             "config-multiaccountsetup.amazonaws.com",
 *         },
 *         FeatureSet = "ALL",
 *     });
 *     var example = new Aws.Cfg.OrganizationConformancePack("example", new()
 *     {
 *         Name = "example",
 *         InputParameters = new[]
 *         {
 *             new Aws.Cfg.Inputs.OrganizationConformancePackInputParameterArgs
 *             {
 *                 ParameterName = "AccessKeysRotatedParameterMaxAccessKeyAge",
 *                 ParameterValue = "90",
 *             },
 *         },
 *         TemplateBody = @"Parameters:
 *   AccessKeysRotatedParameterMaxAccessKeyAge:
 *     Type: String
 * Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 * ",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsConfigConfigurationRecorder,
 *             exampleOrganization,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cfg"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/organizations"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleOrganization, err := organizations.NewOrganization(ctx, "example", &organizations.OrganizationArgs{
 * 			AwsServiceAccessPrincipals: pulumi.StringArray{
 * 				pulumi.String("config-multiaccountsetup.amazonaws.com"),
 * 			},
 * 			FeatureSet: pulumi.String("ALL"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cfg.NewOrganizationConformancePack(ctx, "example", &cfg.OrganizationConformancePackArgs{
 * 			Name: pulumi.String("example"),
 * 			InputParameters: cfg.OrganizationConformancePackInputParameterArray{
 * 				&cfg.OrganizationConformancePackInputParameterArgs{
 * 					ParameterName:  pulumi.String("AccessKeysRotatedParameterMaxAccessKeyAge"),
 * 					ParameterValue: pulumi.String("90"),
 * 				},
 * 			},
 * 			TemplateBody: pulumi.String(`Parameters:
 *   AccessKeysRotatedParameterMaxAccessKeyAge:
 *     Type: String
 * Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 * `),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsConfigConfigurationRecorder,
 * 			exampleOrganization,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.Organization;
 * import com.pulumi.aws.organizations.OrganizationArgs;
 * import com.pulumi.aws.cfg.OrganizationConformancePack;
 * import com.pulumi.aws.cfg.OrganizationConformancePackArgs;
 * import com.pulumi.aws.cfg.inputs.OrganizationConformancePackInputParameterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleOrganization = new Organization("exampleOrganization", OrganizationArgs.builder()
 *             .awsServiceAccessPrincipals("config-multiaccountsetup.amazonaws.com")
 *             .featureSet("ALL")
 *             .build());
 *         var example = new OrganizationConformancePack("example", OrganizationConformancePackArgs.builder()
 *             .name("example")
 *             .inputParameters(OrganizationConformancePackInputParameterArgs.builder()
 *                 .parameterName("AccessKeysRotatedParameterMaxAccessKeyAge")
 *                 .parameterValue("90")
 *                 .build())
 *             .templateBody("""
 * Parameters:
 *   AccessKeysRotatedParameterMaxAccessKeyAge:
 *     Type: String
 * Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 *             """)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     exampleAwsConfigConfigurationRecorder,
 *                     exampleOrganization)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cfg:OrganizationConformancePack
 *     properties:
 *       name: example
 *       inputParameters:
 *         - parameterName: AccessKeysRotatedParameterMaxAccessKeyAge
 *           parameterValue: '90'
 *       templateBody: |
 *         Parameters:
 *           AccessKeysRotatedParameterMaxAccessKeyAge:
 *             Type: String
 *         Resources:
 *           IAMPasswordPolicy:
 *             Properties:
 *               ConfigRuleName: IAMPasswordPolicy
 *               Source:
 *                 Owner: AWS
 *                 SourceIdentifier: IAM_PASSWORD_POLICY
 *             Type: AWS::Config::ConfigRule
 *     options:
 *       dependson:
 *         - ${exampleAwsConfigConfigurationRecorder}
 *         - ${exampleOrganization}
 *   exampleOrganization:
 *     type: aws:organizations:Organization
 *     name: example
 *     properties:
 *       awsServiceAccessPrincipals:
 *         - config-multiaccountsetup.amazonaws.com
 *       featureSet: ALL
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Using Template S3 URI
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleOrganization = new aws.organizations.Organization("example", {
 *     awsServiceAccessPrincipals: ["config-multiaccountsetup&#46;amazonaws&#46;com"],
 *     featureSet: "ALL",
 * });
 * const exampleBucketV2 = new aws.s3.BucketV2("example", {bucket: "example"});
 * const exampleBucketObjectv2 = new aws.s3.BucketObjectv2("example", {
 *     bucket: exampleBucketV2.id,
 *     key: "example-key",
 *     content: `Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 * `,
 * });
 * const example = new aws.cfg.OrganizationConformancePack("example", {
 *     name: "example",
 *     templateS3Uri: pulumi.interpolate`s3://${exampleBucketV2.bucket}/${exampleBucketObjectv2.key}`,
 * }, {
 *     dependsOn: [
 *         exampleAwsConfigConfigurationRecorder,
 *         exampleOrganization,
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_organization = aws.organizations.Organization("example",
 *     aws_service_access_principals=["config-multiaccountsetup&#46;amazonaws&#46;com"],
 *     feature_set="ALL")
 * example_bucket_v2 = aws.s3.BucketV2("example", bucket="example")
 * example_bucket_objectv2 = aws.s3.BucketObjectv2("example",
 *     bucket=example_bucket_v2.id,
 *     key="example-key",
 *     content="""Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 * """)
 * example = aws.cfg.OrganizationConformancePack("example",
 *     name="example",
 *     template_s3_uri=pulumi.Output.all(example_bucket_v2.bucket, example_bucket_objectv2.key).apply(lambda bucket, key: f"s3://{bucket}/{key}"),
 *     opts = pulumi.ResourceOptions(depends_on=[
 *             example_aws_config_configuration_recorder,
 *             example_organization,
 *         ]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleOrganization = new Aws.Organizations.Organization("example", new()
 *     {
 *         AwsServiceAccessPrincipals = new[]
 *         {
 *             "config-multiaccountsetup.amazonaws.com",
 *         },
 *         FeatureSet = "ALL",
 *     });
 *     var exampleBucketV2 = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example",
 *     });
 *     var exampleBucketObjectv2 = new Aws.S3.BucketObjectv2("example", new()
 *     {
 *         Bucket = exampleBucketV2.Id,
 *         Key = "example-key",
 *         Content = @"Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 * ",
 *     });
 *     var example = new Aws.Cfg.OrganizationConformancePack("example", new()
 *     {
 *         Name = "example",
 *         TemplateS3Uri = Output.Tuple(exampleBucketV2.Bucket, exampleBucketObjectv2.Key).Apply(values =>
 *         {
 *             var bucket = values.Item1;
 *             var key = values.Item2;
 *             return $"s3://{bucket}/{key}";
 *         }),
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsConfigConfigurationRecorder,
 *             exampleOrganization,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cfg"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/organizations"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleOrganization, err := organizations.NewOrganization(ctx, "example", &organizations.OrganizationArgs{
 * 			AwsServiceAccessPrincipals: pulumi.StringArray{
 * 				pulumi.String("config-multiaccountsetup.amazonaws.com"),
 * 			},
 * 			FeatureSet: pulumi.String("ALL"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleBucketV2, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleBucketObjectv2, err := s3.NewBucketObjectv2(ctx, "example", &s3.BucketObjectv2Args{
 * 			Bucket: exampleBucketV2.ID(),
 * 			Key:    pulumi.String("example-key"),
 * 			Content: pulumi.String(`Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cfg.NewOrganizationConformancePack(ctx, "example", &cfg.OrganizationConformancePackArgs{
 * 			Name: pulumi.String("example"),
 * 			TemplateS3Uri: pulumi.All(exampleBucketV2.Bucket, exampleBucketObjectv2.Key).ApplyT(func(_args []interface{}) (string, error) {
 * 				bucket := _args[0].(string)
 * 				key := _args[1].(string)
 * 				return fmt.Sprintf("s3://%v/%v", bucket, key), nil
 * 			}).(pulumi.StringOutput),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsConfigConfigurationRecorder,
 * 			exampleOrganization,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.Organization;
 * import com.pulumi.aws.organizations.OrganizationArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.cfg.OrganizationConformancePack;
 * import com.pulumi.aws.cfg.OrganizationConformancePackArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleOrganization = new Organization("exampleOrganization", OrganizationArgs.builder()
 *             .awsServiceAccessPrincipals("config-multiaccountsetup.amazonaws.com")
 *             .featureSet("ALL")
 *             .build());
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .bucket("example")
 *             .build());
 *         var exampleBucketObjectv2 = new BucketObjectv2("exampleBucketObjectv2", BucketObjectv2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .key("example-key")
 *             .content("""
 * Resources:
 *   IAMPasswordPolicy:
 *     Properties:
 *       ConfigRuleName: IAMPasswordPolicy
 *       Source:
 *         Owner: AWS
 *         SourceIdentifier: IAM_PASSWORD_POLICY
 *     Type: AWS::Config::ConfigRule
 *             """)
 *             .build());
 *         var example = new OrganizationConformancePack("example", OrganizationConformancePackArgs.builder()
 *             .name("example")
 *             .templateS3Uri(Output.tuple(exampleBucketV2.bucket(), exampleBucketObjectv2.key()).applyValue(values -> {
 *                 var bucket = values.t1;
 *                 var key = values.t2;
 *                 return String.format("s3://%s/%s", bucket,key);
 *             }))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     exampleAwsConfigConfigurationRecorder,
 *                     exampleOrganization)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cfg:OrganizationConformancePack
 *     properties:
 *       name: example
 *       templateS3Uri: s3://${exampleBucketV2.bucket}/${exampleBucketObjectv2.key}
 *     options:
 *       dependson:
 *         - ${exampleAwsConfigConfigurationRecorder}
 *         - ${exampleOrganization}
 *   exampleOrganization:
 *     type: aws:organizations:Organization
 *     name: example
 *     properties:
 *       awsServiceAccessPrincipals:
 *         - config-multiaccountsetup.amazonaws.com
 *       featureSet: ALL
 *   exampleBucketV2:
 *     type: aws:s3:BucketV2
 *     name: example
 *     properties:
 *       bucket: example
 *   exampleBucketObjectv2:
 *     type: aws:s3:BucketObjectv2
 *     name: example
 *     properties:
 *       bucket: ${exampleBucketV2.id}
 *       key: example-key
 *       content: |
 *         Resources:
 *           IAMPasswordPolicy:
 *             Properties:
 *               ConfigRuleName: IAMPasswordPolicy
 *               Source:
 *                 Owner: AWS
 *                 SourceIdentifier: IAM_PASSWORD_POLICY
 *             Type: AWS::Config::ConfigRule
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Config Organization Conformance Packs using the `name`. For example:
 * ```sh
 * $ pulumi import aws:cfg/organizationConformancePack:OrganizationConformancePack example example
 * ```
 */
public class OrganizationConformancePack internal constructor(
    override val javaResource: com.pulumi.aws.cfg.OrganizationConformancePack,
) : KotlinCustomResource(javaResource, OrganizationConformancePackMapper) {
    /**
     * Amazon Resource Name (ARN) of the organization conformance pack.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Amazon S3 bucket where AWS Config stores conformance pack templates. Delivery bucket must begin with `awsconfigconforms` prefix. Maximum length of 63.
     */
    public val deliveryS3Bucket: Output<String>?
        get() = javaResource.deliveryS3Bucket().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The prefix for the Amazon S3 bucket. Maximum length of 1024.
     */
    public val deliveryS3KeyPrefix: Output<String>?
        get() = javaResource.deliveryS3KeyPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Set of AWS accounts to be excluded from an organization conformance pack while deploying a conformance pack. Maximum of 1000 accounts.
     */
    public val excludedAccounts: Output<List<String>>?
        get() = javaResource.excludedAccounts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Set of configuration blocks describing input parameters passed to the conformance pack template. Documented below. When configured, the parameters must also be included in the `template_body` or in the template stored in Amazon S3 if using `template_s3_uri`.
     */
    public val inputParameters: Output<List<OrganizationConformancePackInputParameter>>?
        get() = javaResource.inputParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The name of the organization conformance pack. Must begin with a letter and contain from 1 to 128 alphanumeric characters and hyphens.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A string containing full conformance pack template body. Maximum length of 51200. Drift detection is not possible with this argument.
     */
    public val templateBody: Output<String>?
        get() = javaResource.templateBody().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Location of file, e.g., `s3://bucketname/prefix`, containing the template body. The uri must point to the conformance pack template that is located in an Amazon S3 bucket in the same region as the conformance pack. Maximum length of 1024. Drift detection is not possible with this argument.
     */
    public val templateS3Uri: Output<String>?
        get() = javaResource.templateS3Uri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object OrganizationConformancePackMapper : ResourceMapper<OrganizationConformancePack> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cfg.OrganizationConformancePack::class == javaResource::class

    override fun map(javaResource: Resource): OrganizationConformancePack =
        OrganizationConformancePack(javaResource as com.pulumi.aws.cfg.OrganizationConformancePack)
}

/**
 * @see [OrganizationConformancePack].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OrganizationConformancePack].
 */
public suspend fun organizationConformancePack(
    name: String,
    block: suspend OrganizationConformancePackResourceBuilder.() -> Unit,
): OrganizationConformancePack {
    val builder = OrganizationConformancePackResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OrganizationConformancePack].
 * @param name The _unique_ name of the resulting resource.
 */
public fun organizationConformancePack(name: String): OrganizationConformancePack {
    val builder = OrganizationConformancePackResourceBuilder()
    builder.name(name)
    return builder.build()
}
