@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [OrganizationCustomRule].
 */
@PulumiTagMarker
public class OrganizationCustomRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrganizationCustomRuleArgs = OrganizationCustomRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrganizationCustomRuleArgsBuilder.() -> Unit) {
        val builder = OrganizationCustomRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OrganizationCustomRule {
        val builtJavaResource = com.pulumi.aws.cfg.OrganizationCustomRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OrganizationCustomRule(builtJavaResource)
    }
}

/**
 * Manages a Config Organization Custom Rule. More information about these rules can be found in the [Enabling AWS Config Rules Across all Accounts in Your Organization](https://docs&#46;aws&#46;amazon&#46;com/config/latest/developerguide/config-rule-multi-account-deployment&#46;html) and [AWS Config Managed Rules](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html) documentation. For working with Organization Managed Rules (those invoking an AWS managed rule), see the `aws_config_organization_managed__rule` resource.
 * > **NOTE:** This resource must be created in the Organization master account and rules will include the master account unless its ID is added to the `excluded_accounts` argument.
 * > **NOTE:** The proper Lambda permission to allow the AWS Config service invoke the Lambda Function must be in place before the rule will successfully create or update. See also the `aws.lambda.Permission` resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lambda.Permission("example", {
 *     action: "lambda:InvokeFunction",
 *     "function": exampleAwsLambdaFunction.arn,
 *     principal: "config.amazonaws.com",
 *     statementId: "AllowExecutionFromConfig",
 * });
 * const exampleOrganization = new aws.organizations.Organization("example", {
 *     awsServiceAccessPrincipals: ["config-multiaccountsetup&#46;amazonaws&#46;com"],
 *     featureSet: "ALL",
 * });
 * const exampleOrganizationCustomRule = new aws.cfg.OrganizationCustomRule("example", {
 *     lambdaFunctionArn: exampleAwsLambdaFunction.arn,
 *     name: "example",
 *     triggerTypes: ["ConfigurationItemChangeNotification"],
 * }, {
 *     dependsOn: [
 *         example,
 *         exampleOrganization,
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lambda_.Permission("example",
 *     action="lambda:InvokeFunction",
 *     function=example_aws_lambda_function["arn"],
 *     principal="config.amazonaws.com",
 *     statement_id="AllowExecutionFromConfig")
 * example_organization = aws.organizations.Organization("example",
 *     aws_service_access_principals=["config-multiaccountsetup&#46;amazonaws&#46;com"],
 *     feature_set="ALL")
 * example_organization_custom_rule = aws.cfg.OrganizationCustomRule("example",
 *     lambda_function_arn=example_aws_lambda_function["arn"],
 *     name="example",
 *     trigger_types=["ConfigurationItemChangeNotification"],
 *     opts = pulumi.ResourceOptions(depends_on=[
 *             example,
 *             example_organization,
 *         ]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lambda.Permission("example", new()
 *     {
 *         Action = "lambda:InvokeFunction",
 *         Function = exampleAwsLambdaFunction.Arn,
 *         Principal = "config.amazonaws.com",
 *         StatementId = "AllowExecutionFromConfig",
 *     });
 *     var exampleOrganization = new Aws.Organizations.Organization("example", new()
 *     {
 *         AwsServiceAccessPrincipals = new[]
 *         {
 *             "config-multiaccountsetup.amazonaws.com",
 *         },
 *         FeatureSet = "ALL",
 *     });
 *     var exampleOrganizationCustomRule = new Aws.Cfg.OrganizationCustomRule("example", new()
 *     {
 *         LambdaFunctionArn = exampleAwsLambdaFunction.Arn,
 *         Name = "example",
 *         TriggerTypes = new[]
 *         {
 *             "ConfigurationItemChangeNotification",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *             exampleOrganization,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cfg"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/organizations"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := lambda.NewPermission(ctx, "example", &lambda.PermissionArgs{
 * 			Action:      pulumi.String("lambda:InvokeFunction"),
 * 			Function:    pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 			Principal:   pulumi.String("config.amazonaws.com"),
 * 			StatementId: pulumi.String("AllowExecutionFromConfig"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleOrganization, err := organizations.NewOrganization(ctx, "example", &organizations.OrganizationArgs{
 * 			AwsServiceAccessPrincipals: pulumi.StringArray{
 * 				pulumi.String("config-multiaccountsetup.amazonaws.com"),
 * 			},
 * 			FeatureSet: pulumi.String("ALL"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cfg.NewOrganizationCustomRule(ctx, "example", &cfg.OrganizationCustomRuleArgs{
 * 			LambdaFunctionArn: pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 			Name:              pulumi.String("example"),
 * 			TriggerTypes: pulumi.StringArray{
 * 				pulumi.String("ConfigurationItemChangeNotification"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 			exampleOrganization,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.Permission;
 * import com.pulumi.aws.lambda.PermissionArgs;
 * import com.pulumi.aws.organizations.Organization;
 * import com.pulumi.aws.organizations.OrganizationArgs;
 * import com.pulumi.aws.cfg.OrganizationCustomRule;
 * import com.pulumi.aws.cfg.OrganizationCustomRuleArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Permission("example", PermissionArgs.builder()
 *             .action("lambda:InvokeFunction")
 *             .function(exampleAwsLambdaFunction.arn())
 *             .principal("config.amazonaws.com")
 *             .statementId("AllowExecutionFromConfig")
 *             .build());
 *         var exampleOrganization = new Organization("exampleOrganization", OrganizationArgs.builder()
 *             .awsServiceAccessPrincipals("config-multiaccountsetup.amazonaws.com")
 *             .featureSet("ALL")
 *             .build());
 *         var exampleOrganizationCustomRule = new OrganizationCustomRule("exampleOrganizationCustomRule", OrganizationCustomRuleArgs.builder()
 *             .lambdaFunctionArn(exampleAwsLambdaFunction.arn())
 *             .name("example")
 *             .triggerTypes("ConfigurationItemChangeNotification")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     example,
 *                     exampleOrganization)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lambda:Permission
 *     properties:
 *       action: lambda:InvokeFunction
 *       function: ${exampleAwsLambdaFunction.arn}
 *       principal: config.amazonaws.com
 *       statementId: AllowExecutionFromConfig
 *   exampleOrganization:
 *     type: aws:organizations:Organization
 *     name: example
 *     properties:
 *       awsServiceAccessPrincipals:
 *         - config-multiaccountsetup.amazonaws.com
 *       featureSet: ALL
 *   exampleOrganizationCustomRule:
 *     type: aws:cfg:OrganizationCustomRule
 *     name: example
 *     properties:
 *       lambdaFunctionArn: ${exampleAwsLambdaFunction.arn}
 *       name: example
 *       triggerTypes:
 *         - ConfigurationItemChangeNotification
 *     options:
 *       dependson:
 *         - ${example}
 *         - ${exampleOrganization}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Config Organization Custom Rules using the name. For example:
 * ```sh
 * $ pulumi import aws:cfg/organizationCustomRule:OrganizationCustomRule example example
 * ```
 */
public class OrganizationCustomRule internal constructor(
    override val javaResource: com.pulumi.aws.cfg.OrganizationCustomRule,
) : KotlinCustomResource(javaResource, OrganizationCustomRuleMapper) {
    /**
     * Amazon Resource Name (ARN) of the rule
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the rule
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of AWS account identifiers to exclude from the rule
     */
    public val excludedAccounts: Output<List<String>>?
        get() = javaResource.excludedAccounts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * A string in JSON format that is passed to the AWS Config Rule Lambda Function
     */
    public val inputParameters: Output<String>?
        get() = javaResource.inputParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of the rule Lambda Function
     */
    public val lambdaFunctionArn: Output<String>
        get() = javaResource.lambdaFunctionArn().applyValue({ args0 -> args0 })

    /**
     * The maximum frequency with which AWS Config runs evaluations for a rule, if the rule is triggered at a periodic frequency. Defaults to `TwentyFour_Hours` for periodic frequency triggered rules. Valid values: `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, or `TwentyFour_Hours`.
     */
    public val maximumExecutionFrequency: Output<String>?
        get() = javaResource.maximumExecutionFrequency().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the rule
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Identifier of the AWS resource to evaluate
     */
    public val resourceIdScope: Output<String>?
        get() = javaResource.resourceIdScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of types of AWS resources to evaluate
     */
    public val resourceTypesScopes: Output<List<String>>?
        get() = javaResource.resourceTypesScopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Tag key of AWS resources to evaluate
     */
    public val tagKeyScope: Output<String>?
        get() = javaResource.tagKeyScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Tag value of AWS resources to evaluate
     */
    public val tagValueScope: Output<String>?
        get() = javaResource.tagValueScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of notification types that trigger AWS Config to run an evaluation for the rule. Valid values: `ConfigurationItemChangeNotification`, `OversizedConfigurationItemChangeNotification`, and `ScheduledNotification`
     */
    public val triggerTypes: Output<List<String>>
        get() = javaResource.triggerTypes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object OrganizationCustomRuleMapper : ResourceMapper<OrganizationCustomRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cfg.OrganizationCustomRule::class == javaResource::class

    override fun map(javaResource: Resource): OrganizationCustomRule =
        OrganizationCustomRule(javaResource as com.pulumi.aws.cfg.OrganizationCustomRule)
}

/**
 * @see [OrganizationCustomRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OrganizationCustomRule].
 */
public suspend fun organizationCustomRule(
    name: String,
    block: suspend OrganizationCustomRuleResourceBuilder.() -> Unit,
): OrganizationCustomRule {
    val builder = OrganizationCustomRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OrganizationCustomRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun organizationCustomRule(name: String): OrganizationCustomRule {
    val builder = OrganizationCustomRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
