@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [OrganizationManagedRule].
 */
@PulumiTagMarker
public class OrganizationManagedRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrganizationManagedRuleArgs = OrganizationManagedRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrganizationManagedRuleArgsBuilder.() -> Unit) {
        val builder = OrganizationManagedRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OrganizationManagedRule {
        val builtJavaResource = com.pulumi.aws.cfg.OrganizationManagedRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OrganizationManagedRule(builtJavaResource)
    }
}

/**
 * Manages a Config Organization Managed Rule. More information about these rules can be found in the [Enabling AWS Config Rules Across all Accounts in Your Organization](https://docs&#46;aws&#46;amazon&#46;com/config/latest/developerguide/config-rule-multi-account-deployment&#46;html) and [AWS Config Managed Rules](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html) documentation. For working with Organization Custom Rules (those invoking a custom Lambda Function), see the `aws.cfg.OrganizationCustomRule` resource.
 * > **NOTE:** This resource must be created in the Organization master account and rules will include the master account unless its ID is added to the `excluded_accounts` argument.
 * > **NOTE:** Every Organization account except those configured in the `excluded_accounts` argument must have a Configuration Recorder with proper IAM permissions before the rule will successfully create or update. See also the `aws.cfg.Recorder` resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.organizations.Organization("example", {
 *     awsServiceAccessPrincipals: ["config-multiaccountsetup&#46;amazonaws&#46;com"],
 *     featureSet: "ALL",
 * });
 * const exampleOrganizationManagedRule = new aws.cfg.OrganizationManagedRule("example", {
 *     name: "example",
 *     ruleIdentifier: "IAM_PASSWORD_POLICY",
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.organizations.Organization("example",
 *     aws_service_access_principals=["config-multiaccountsetup&#46;amazonaws&#46;com"],
 *     feature_set="ALL")
 * example_organization_managed_rule = aws.cfg.OrganizationManagedRule("example",
 *     name="example",
 *     rule_identifier="IAM_PASSWORD_POLICY",
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Organizations.Organization("example", new()
 *     {
 *         AwsServiceAccessPrincipals = new[]
 *         {
 *             "config-multiaccountsetup.amazonaws.com",
 *         },
 *         FeatureSet = "ALL",
 *     });
 *     var exampleOrganizationManagedRule = new Aws.Cfg.OrganizationManagedRule("example", new()
 *     {
 *         Name = "example",
 *         RuleIdentifier = "IAM_PASSWORD_POLICY",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cfg"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/organizations"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := organizations.NewOrganization(ctx, "example", &organizations.OrganizationArgs{
 * 			AwsServiceAccessPrincipals: pulumi.StringArray{
 * 				pulumi.String("config-multiaccountsetup.amazonaws.com"),
 * 			},
 * 			FeatureSet: pulumi.String("ALL"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cfg.NewOrganizationManagedRule(ctx, "example", &cfg.OrganizationManagedRuleArgs{
 * 			Name:           pulumi.String("example"),
 * 			RuleIdentifier: pulumi.String("IAM_PASSWORD_POLICY"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.Organization;
 * import com.pulumi.aws.organizations.OrganizationArgs;
 * import com.pulumi.aws.cfg.OrganizationManagedRule;
 * import com.pulumi.aws.cfg.OrganizationManagedRuleArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Organization("example", OrganizationArgs.builder()
 *             .awsServiceAccessPrincipals("config-multiaccountsetup.amazonaws.com")
 *             .featureSet("ALL")
 *             .build());
 *         var exampleOrganizationManagedRule = new OrganizationManagedRule("exampleOrganizationManagedRule", OrganizationManagedRuleArgs.builder()
 *             .name("example")
 *             .ruleIdentifier("IAM_PASSWORD_POLICY")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:organizations:Organization
 *     properties:
 *       awsServiceAccessPrincipals:
 *         - config-multiaccountsetup.amazonaws.com
 *       featureSet: ALL
 *   exampleOrganizationManagedRule:
 *     type: aws:cfg:OrganizationManagedRule
 *     name: example
 *     properties:
 *       name: example
 *       ruleIdentifier: IAM_PASSWORD_POLICY
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Config Organization Managed Rules using the name. For example:
 * ```sh
 * $ pulumi import aws:cfg/organizationManagedRule:OrganizationManagedRule example example
 * ```
 */
public class OrganizationManagedRule internal constructor(
    override val javaResource: com.pulumi.aws.cfg.OrganizationManagedRule,
) : KotlinCustomResource(javaResource, OrganizationManagedRuleMapper) {
    /**
     * Amazon Resource Name (ARN) of the rule
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the rule
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of AWS account identifiers to exclude from the rule
     */
    public val excludedAccounts: Output<List<String>>?
        get() = javaResource.excludedAccounts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * A string in JSON format that is passed to the AWS Config Rule Lambda Function
     */
    public val inputParameters: Output<String>?
        get() = javaResource.inputParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum frequency with which AWS Config runs evaluations for a rule, if the rule is triggered at a periodic frequency. Defaults to `TwentyFour_Hours` for periodic frequency triggered rules. Valid values: `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, or `TwentyFour_Hours`.
     */
    public val maximumExecutionFrequency: Output<String>?
        get() = javaResource.maximumExecutionFrequency().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the rule
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Identifier of the AWS resource to evaluate
     */
    public val resourceIdScope: Output<String>?
        get() = javaResource.resourceIdScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of types of AWS resources to evaluate
     */
    public val resourceTypesScopes: Output<List<String>>?
        get() = javaResource.resourceTypesScopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Identifier of an available AWS Config Managed Rule to call. For available values, see the [List of AWS Config Managed Rules](https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html) documentation
     */
    public val ruleIdentifier: Output<String>
        get() = javaResource.ruleIdentifier().applyValue({ args0 -> args0 })

    /**
     * Tag key of AWS resources to evaluate
     */
    public val tagKeyScope: Output<String>?
        get() = javaResource.tagKeyScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Tag value of AWS resources to evaluate
     */
    public val tagValueScope: Output<String>?
        get() = javaResource.tagValueScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object OrganizationManagedRuleMapper : ResourceMapper<OrganizationManagedRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cfg.OrganizationManagedRule::class == javaResource::class

    override fun map(javaResource: Resource): OrganizationManagedRule =
        OrganizationManagedRule(javaResource as com.pulumi.aws.cfg.OrganizationManagedRule)
}

/**
 * @see [OrganizationManagedRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OrganizationManagedRule].
 */
public suspend fun organizationManagedRule(
    name: String,
    block: suspend OrganizationManagedRuleResourceBuilder.() -> Unit,
): OrganizationManagedRule {
    val builder = OrganizationManagedRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OrganizationManagedRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun organizationManagedRule(name: String): OrganizationManagedRule {
    val builder = OrganizationManagedRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
