@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.aws.cfg.OrganizationManagedRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages a Config Organization Managed Rule. More information about these rules can be found in the [Enabling AWS Config Rules Across all Accounts in Your Organization](https://docs&#46;aws&#46;amazon&#46;com/config/latest/developerguide/config-rule-multi-account-deployment&#46;html) and [AWS Config Managed Rules](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html) documentation. For working with Organization Custom Rules (those invoking a custom Lambda Function), see the `aws.cfg.OrganizationCustomRule` resource.
 * > **NOTE:** This resource must be created in the Organization master account and rules will include the master account unless its ID is added to the `excluded_accounts` argument.
 * > **NOTE:** Every Organization account except those configured in the `excluded_accounts` argument must have a Configuration Recorder with proper IAM permissions before the rule will successfully create or update. See also the `aws.cfg.Recorder` resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.organizations.Organization("example", {
 *     awsServiceAccessPrincipals: ["config-multiaccountsetup&#46;amazonaws&#46;com"],
 *     featureSet: "ALL",
 * });
 * const exampleOrganizationManagedRule = new aws.cfg.OrganizationManagedRule("example", {
 *     name: "example",
 *     ruleIdentifier: "IAM_PASSWORD_POLICY",
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.organizations.Organization("example",
 *     aws_service_access_principals=["config-multiaccountsetup&#46;amazonaws&#46;com"],
 *     feature_set="ALL")
 * example_organization_managed_rule = aws.cfg.OrganizationManagedRule("example",
 *     name="example",
 *     rule_identifier="IAM_PASSWORD_POLICY",
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Organizations.Organization("example", new()
 *     {
 *         AwsServiceAccessPrincipals = new[]
 *         {
 *             "config-multiaccountsetup.amazonaws.com",
 *         },
 *         FeatureSet = "ALL",
 *     });
 *     var exampleOrganizationManagedRule = new Aws.Cfg.OrganizationManagedRule("example", new()
 *     {
 *         Name = "example",
 *         RuleIdentifier = "IAM_PASSWORD_POLICY",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cfg"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/organizations"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := organizations.NewOrganization(ctx, "example", &organizations.OrganizationArgs{
 * 			AwsServiceAccessPrincipals: pulumi.StringArray{
 * 				pulumi.String("config-multiaccountsetup.amazonaws.com"),
 * 			},
 * 			FeatureSet: pulumi.String("ALL"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cfg.NewOrganizationManagedRule(ctx, "example", &cfg.OrganizationManagedRuleArgs{
 * 			Name:           pulumi.String("example"),
 * 			RuleIdentifier: pulumi.String("IAM_PASSWORD_POLICY"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.Organization;
 * import com.pulumi.aws.organizations.OrganizationArgs;
 * import com.pulumi.aws.cfg.OrganizationManagedRule;
 * import com.pulumi.aws.cfg.OrganizationManagedRuleArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Organization("example", OrganizationArgs.builder()
 *             .awsServiceAccessPrincipals("config-multiaccountsetup.amazonaws.com")
 *             .featureSet("ALL")
 *             .build());
 *         var exampleOrganizationManagedRule = new OrganizationManagedRule("exampleOrganizationManagedRule", OrganizationManagedRuleArgs.builder()
 *             .name("example")
 *             .ruleIdentifier("IAM_PASSWORD_POLICY")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:organizations:Organization
 *     properties:
 *       awsServiceAccessPrincipals:
 *         - config-multiaccountsetup.amazonaws.com
 *       featureSet: ALL
 *   exampleOrganizationManagedRule:
 *     type: aws:cfg:OrganizationManagedRule
 *     name: example
 *     properties:
 *       name: example
 *       ruleIdentifier: IAM_PASSWORD_POLICY
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Config Organization Managed Rules using the name. For example:
 * ```sh
 * $ pulumi import aws:cfg/organizationManagedRule:OrganizationManagedRule example example
 * ```
 * @property description Description of the rule
 * @property excludedAccounts List of AWS account identifiers to exclude from the rule
 * @property inputParameters A string in JSON format that is passed to the AWS Config Rule Lambda Function
 * @property maximumExecutionFrequency The maximum frequency with which AWS Config runs evaluations for a rule, if the rule is triggered at a periodic frequency. Defaults to `TwentyFour_Hours` for periodic frequency triggered rules. Valid values: `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, or `TwentyFour_Hours`.
 * @property name The name of the rule
 * @property resourceIdScope Identifier of the AWS resource to evaluate
 * @property resourceTypesScopes List of types of AWS resources to evaluate
 * @property ruleIdentifier Identifier of an available AWS Config Managed Rule to call. For available values, see the [List of AWS Config Managed Rules](https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html) documentation
 * @property tagKeyScope Tag key of AWS resources to evaluate
 * @property tagValueScope Tag value of AWS resources to evaluate
 */
public data class OrganizationManagedRuleArgs(
    public val description: Output<String>? = null,
    public val excludedAccounts: Output<List<String>>? = null,
    public val inputParameters: Output<String>? = null,
    public val maximumExecutionFrequency: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceIdScope: Output<String>? = null,
    public val resourceTypesScopes: Output<List<String>>? = null,
    public val ruleIdentifier: Output<String>? = null,
    public val tagKeyScope: Output<String>? = null,
    public val tagValueScope: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.OrganizationManagedRuleArgs> {
    override fun toJava(): com.pulumi.aws.cfg.OrganizationManagedRuleArgs =
        com.pulumi.aws.cfg.OrganizationManagedRuleArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .excludedAccounts(excludedAccounts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .inputParameters(inputParameters?.applyValue({ args0 -> args0 }))
            .maximumExecutionFrequency(maximumExecutionFrequency?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceIdScope(resourceIdScope?.applyValue({ args0 -> args0 }))
            .resourceTypesScopes(resourceTypesScopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ruleIdentifier(ruleIdentifier?.applyValue({ args0 -> args0 }))
            .tagKeyScope(tagKeyScope?.applyValue({ args0 -> args0 }))
            .tagValueScope(tagValueScope?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OrganizationManagedRuleArgs].
 */
@PulumiTagMarker
public class OrganizationManagedRuleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var excludedAccounts: Output<List<String>>? = null

    private var inputParameters: Output<String>? = null

    private var maximumExecutionFrequency: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceIdScope: Output<String>? = null

    private var resourceTypesScopes: Output<List<String>>? = null

    private var ruleIdentifier: Output<String>? = null

    private var tagKeyScope: Output<String>? = null

    private var tagValueScope: Output<String>? = null

    /**
     * @param value Description of the rule
     */
    @JvmName("kkyhshxqggkqvpuh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value List of AWS account identifiers to exclude from the rule
     */
    @JvmName("yniunyaunvgtsind")
    public suspend fun excludedAccounts(`value`: Output<List<String>>) {
        this.excludedAccounts = value
    }

    @JvmName("simejlhtataikneo")
    public suspend fun excludedAccounts(vararg values: Output<String>) {
        this.excludedAccounts = Output.all(values.asList())
    }

    /**
     * @param values List of AWS account identifiers to exclude from the rule
     */
    @JvmName("mveihydbkhkuciae")
    public suspend fun excludedAccounts(values: List<Output<String>>) {
        this.excludedAccounts = Output.all(values)
    }

    /**
     * @param value A string in JSON format that is passed to the AWS Config Rule Lambda Function
     */
    @JvmName("utykgxdfubgsiiip")
    public suspend fun inputParameters(`value`: Output<String>) {
        this.inputParameters = value
    }

    /**
     * @param value The maximum frequency with which AWS Config runs evaluations for a rule, if the rule is triggered at a periodic frequency. Defaults to `TwentyFour_Hours` for periodic frequency triggered rules. Valid values: `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, or `TwentyFour_Hours`.
     */
    @JvmName("bhggfsyuotckftnn")
    public suspend fun maximumExecutionFrequency(`value`: Output<String>) {
        this.maximumExecutionFrequency = value
    }

    /**
     * @param value The name of the rule
     */
    @JvmName("sbocxkdbtuowsxvg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Identifier of the AWS resource to evaluate
     */
    @JvmName("mmtykqyljelmtfgt")
    public suspend fun resourceIdScope(`value`: Output<String>) {
        this.resourceIdScope = value
    }

    /**
     * @param value List of types of AWS resources to evaluate
     */
    @JvmName("waemidpvbvekgqxs")
    public suspend fun resourceTypesScopes(`value`: Output<List<String>>) {
        this.resourceTypesScopes = value
    }

    @JvmName("ffhvpumwmgvjnpyx")
    public suspend fun resourceTypesScopes(vararg values: Output<String>) {
        this.resourceTypesScopes = Output.all(values.asList())
    }

    /**
     * @param values List of types of AWS resources to evaluate
     */
    @JvmName("pvxbdkujskiebqmg")
    public suspend fun resourceTypesScopes(values: List<Output<String>>) {
        this.resourceTypesScopes = Output.all(values)
    }

    /**
     * @param value Identifier of an available AWS Config Managed Rule to call. For available values, see the [List of AWS Config Managed Rules](https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html) documentation
     */
    @JvmName("aqiueygkxhjrvoos")
    public suspend fun ruleIdentifier(`value`: Output<String>) {
        this.ruleIdentifier = value
    }

    /**
     * @param value Tag key of AWS resources to evaluate
     */
    @JvmName("qycfiehxssgjjwxp")
    public suspend fun tagKeyScope(`value`: Output<String>) {
        this.tagKeyScope = value
    }

    /**
     * @param value Tag value of AWS resources to evaluate
     */
    @JvmName("rfldlnsbnhclleue")
    public suspend fun tagValueScope(`value`: Output<String>) {
        this.tagValueScope = value
    }

    /**
     * @param value Description of the rule
     */
    @JvmName("rbotpwysplqhcasq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value List of AWS account identifiers to exclude from the rule
     */
    @JvmName("fqbqwhkxxywibfij")
    public suspend fun excludedAccounts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedAccounts = mapped
    }

    /**
     * @param values List of AWS account identifiers to exclude from the rule
     */
    @JvmName("vqtkynwhqsurcplx")
    public suspend fun excludedAccounts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedAccounts = mapped
    }

    /**
     * @param value A string in JSON format that is passed to the AWS Config Rule Lambda Function
     */
    @JvmName("oaexisvtdvqwfjax")
    public suspend fun inputParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputParameters = mapped
    }

    /**
     * @param value The maximum frequency with which AWS Config runs evaluations for a rule, if the rule is triggered at a periodic frequency. Defaults to `TwentyFour_Hours` for periodic frequency triggered rules. Valid values: `One_Hour`, `Three_Hours`, `Six_Hours`, `Twelve_Hours`, or `TwentyFour_Hours`.
     */
    @JvmName("bvfspqueeslbipid")
    public suspend fun maximumExecutionFrequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumExecutionFrequency = mapped
    }

    /**
     * @param value The name of the rule
     */
    @JvmName("kcgwhrpcpcrmrlhl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Identifier of the AWS resource to evaluate
     */
    @JvmName("whbhmtpxgmluhsyd")
    public suspend fun resourceIdScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceIdScope = mapped
    }

    /**
     * @param value List of types of AWS resources to evaluate
     */
    @JvmName("tpwvcvjfeufvphao")
    public suspend fun resourceTypesScopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypesScopes = mapped
    }

    /**
     * @param values List of types of AWS resources to evaluate
     */
    @JvmName("yqxhmjxlecyoxoqu")
    public suspend fun resourceTypesScopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypesScopes = mapped
    }

    /**
     * @param value Identifier of an available AWS Config Managed Rule to call. For available values, see the [List of AWS Config Managed Rules](https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html) documentation
     */
    @JvmName("nkpijkcirklubjoy")
    public suspend fun ruleIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleIdentifier = mapped
    }

    /**
     * @param value Tag key of AWS resources to evaluate
     */
    @JvmName("rrwugsjtueqawech")
    public suspend fun tagKeyScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagKeyScope = mapped
    }

    /**
     * @param value Tag value of AWS resources to evaluate
     */
    @JvmName("trakoxydevqijwxq")
    public suspend fun tagValueScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagValueScope = mapped
    }

    internal fun build(): OrganizationManagedRuleArgs = OrganizationManagedRuleArgs(
        description = description,
        excludedAccounts = excludedAccounts,
        inputParameters = inputParameters,
        maximumExecutionFrequency = maximumExecutionFrequency,
        name = name,
        resourceIdScope = resourceIdScope,
        resourceTypesScopes = resourceTypesScopes,
        ruleIdentifier = ruleIdentifier,
        tagKeyScope = tagKeyScope,
        tagValueScope = tagValueScope,
    )
}
