@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.aws.cfg.kotlin.outputs.RecorderRecordingGroup
import com.pulumi.aws.cfg.kotlin.outputs.RecorderRecordingMode
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.cfg.kotlin.outputs.RecorderRecordingGroup.Companion.toKotlin as recorderRecordingGroupToKotlin
import com.pulumi.aws.cfg.kotlin.outputs.RecorderRecordingMode.Companion.toKotlin as recorderRecordingModeToKotlin

/**
 * Builder for [Recorder].
 */
@PulumiTagMarker
public class RecorderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RecorderArgs = RecorderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RecorderArgsBuilder.() -> Unit) {
        val builder = RecorderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Recorder {
        val builtJavaResource = com.pulumi.aws.cfg.Recorder(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Recorder(builtJavaResource)
    }
}

/**
 * Provides an AWS Config Configuration Recorder. Please note that this resource **does not start** the created recorder automatically.
 * > **Note:** _Starting_ the Configuration Recorder requires a delivery channel (while delivery channel creation requires Configuration Recorder). This is why `aws.cfg.RecorderStatus` is a separate resource.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["config&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const r = new aws.iam.Role("r", {
 *     name: "awsconfig-example",
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 * });
 * const foo = new aws.cfg.Recorder("foo", {
 *     name: "example",
 *     roleArn: r.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["config&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * r = aws.iam.Role("r",
 *     name="awsconfig-example",
 *     assume_role_policy=assume_role.json)
 * foo = aws.cfg.Recorder("foo",
 *     name="example",
 *     role_arn=r.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "config.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var r = new Aws.Iam.Role("r", new()
 *     {
 *         Name = "awsconfig-example",
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var foo = new Aws.Cfg.Recorder("foo", new()
 *     {
 *         Name = "example",
 *         RoleArn = r.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cfg"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"config.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		r, err := iam.NewRole(ctx, "r", &iam.RoleArgs{
 * 			Name:             pulumi.String("awsconfig-example"),
 * 			AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cfg.NewRecorder(ctx, "foo", &cfg.RecorderArgs{
 * 			Name:    pulumi.String("example"),
 * 			RoleArn: r.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.cfg.Recorder;
 * import com.pulumi.aws.cfg.RecorderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("config.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var r = new Role("r", RoleArgs.builder()
 *             .name("awsconfig-example")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var foo = new Recorder("foo", RecorderArgs.builder()
 *             .name("example")
 *             .roleArn(r.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:cfg:Recorder
 *     properties:
 *       name: example
 *       roleArn: ${r.arn}
 *   r:
 *     type: aws:iam:Role
 *     properties:
 *       name: awsconfig-example
 *       assumeRolePolicy: ${assumeRole.json}
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - config.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Exclude Resources Types Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foo = new aws.cfg.Recorder("foo", {
 *     name: "example",
 *     roleArn: r.arn,
 *     recordingGroup: {
 *         allSupported: false,
 *         exclusionByResourceTypes: [{
 *             resourceTypes: ["AWS::EC2::Instance"],
 *         }],
 *         recordingStrategies: [{
 *             useOnly: "EXCLUSION_BY_RESOURCE_TYPES",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foo = aws.cfg.Recorder("foo",
 *     name="example",
 *     role_arn=r["arn"],
 *     recording_group={
 *         "all_supported": False,
 *         "exclusion_by_resource_types": [{
 *             "resource_types": ["AWS::EC2::Instance"],
 *         }],
 *         "recording_strategies": [{
 *             "use_only": "EXCLUSION_BY_RESOURCE_TYPES",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new Aws.Cfg.Recorder("foo", new()
 *     {
 *         Name = "example",
 *         RoleArn = r.Arn,
 *         RecordingGroup = new Aws.Cfg.Inputs.RecorderRecordingGroupArgs
 *         {
 *             AllSupported = false,
 *             ExclusionByResourceTypes = new[]
 *             {
 *                 new Aws.Cfg.Inputs.RecorderRecordingGroupExclusionByResourceTypeArgs
 *                 {
 *                     ResourceTypes = new[]
 *                     {
 *                         "AWS::EC2::Instance",
 *                     },
 *                 },
 *             },
 *             RecordingStrategies = new[]
 *             {
 *                 new Aws.Cfg.Inputs.RecorderRecordingGroupRecordingStrategyArgs
 *                 {
 *                     UseOnly = "EXCLUSION_BY_RESOURCE_TYPES",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cfg"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cfg.NewRecorder(ctx, "foo", &cfg.RecorderArgs{
 * 			Name:    pulumi.String("example"),
 * 			RoleArn: pulumi.Any(r.Arn),
 * 			RecordingGroup: &cfg.RecorderRecordingGroupArgs{
 * 				AllSupported: pulumi.Bool(false),
 * 				ExclusionByResourceTypes: cfg.RecorderRecordingGroupExclusionByResourceTypeArray{
 * 					&cfg.RecorderRecordingGroupExclusionByResourceTypeArgs{
 * 						ResourceTypes: pulumi.StringArray{
 * 							pulumi.String("AWS::EC2::Instance"),
 * 						},
 * 					},
 * 				},
 * 				RecordingStrategies: cfg.RecorderRecordingGroupRecordingStrategyArray{
 * 					&cfg.RecorderRecordingGroupRecordingStrategyArgs{
 * 						UseOnly: pulumi.String("EXCLUSION_BY_RESOURCE_TYPES"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cfg.Recorder;
 * import com.pulumi.aws.cfg.RecorderArgs;
 * import com.pulumi.aws.cfg.inputs.RecorderRecordingGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Recorder("foo", RecorderArgs.builder()
 *             .name("example")
 *             .roleArn(r.arn())
 *             .recordingGroup(RecorderRecordingGroupArgs.builder()
 *                 .allSupported(false)
 *                 .exclusionByResourceTypes(RecorderRecordingGroupExclusionByResourceTypeArgs.builder()
 *                     .resourceTypes("AWS::EC2::Instance")
 *                     .build())
 *                 .recordingStrategies(RecorderRecordingGroupRecordingStrategyArgs.builder()
 *                     .useOnly("EXCLUSION_BY_RESOURCE_TYPES")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:cfg:Recorder
 *     properties:
 *       name: example
 *       roleArn: ${r.arn}
 *       recordingGroup:
 *         allSupported: false
 *         exclusionByResourceTypes:
 *           - resourceTypes:
 *               - AWS::EC2::Instance
 *         recordingStrategies:
 *           - useOnly: EXCLUSION_BY_RESOURCE_TYPES
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Periodic Recording
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foo = new aws.cfg.Recorder("foo", {
 *     name: "example",
 *     roleArn: r.arn,
 *     recordingGroup: {
 *         allSupported: false,
 *         includeGlobalResourceTypes: false,
 *         resourceTypes: [
 *             "AWS::EC2::Instance",
 *             "AWS::EC2::NetworkInterface",
 *         ],
 *     },
 *     recordingMode: {
 *         recordingFrequency: "CONTINUOUS",
 *         recordingModeOverride: {
 *             description: "Only record EC2 network interfaces daily",
 *             resourceTypes: ["AWS::EC2::NetworkInterface"],
 *             recordingFrequency: "DAILY",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foo = aws.cfg.Recorder("foo",
 *     name="example",
 *     role_arn=r["arn"],
 *     recording_group={
 *         "all_supported": False,
 *         "include_global_resource_types": False,
 *         "resource_types": [
 *             "AWS::EC2::Instance",
 *             "AWS::EC2::NetworkInterface",
 *         ],
 *     },
 *     recording_mode={
 *         "recording_frequency": "CONTINUOUS",
 *         "recording_mode_override": {
 *             "description": "Only record EC2 network interfaces daily",
 *             "resource_types": ["AWS::EC2::NetworkInterface"],
 *             "recording_frequency": "DAILY",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new Aws.Cfg.Recorder("foo", new()
 *     {
 *         Name = "example",
 *         RoleArn = r.Arn,
 *         RecordingGroup = new Aws.Cfg.Inputs.RecorderRecordingGroupArgs
 *         {
 *             AllSupported = false,
 *             IncludeGlobalResourceTypes = false,
 *             ResourceTypes = new[]
 *             {
 *                 "AWS::EC2::Instance",
 *                 "AWS::EC2::NetworkInterface",
 *             },
 *         },
 *         RecordingMode = new Aws.Cfg.Inputs.RecorderRecordingModeArgs
 *         {
 *             RecordingFrequency = "CONTINUOUS",
 *             RecordingModeOverride = new Aws.Cfg.Inputs.RecorderRecordingModeRecordingModeOverrideArgs
 *             {
 *                 Description = "Only record EC2 network interfaces daily",
 *                 ResourceTypes = new[]
 *                 {
 *                     "AWS::EC2::NetworkInterface",
 *                 },
 *                 RecordingFrequency = "DAILY",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cfg"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cfg.NewRecorder(ctx, "foo", &cfg.RecorderArgs{
 * 			Name:    pulumi.String("example"),
 * 			RoleArn: pulumi.Any(r.Arn),
 * 			RecordingGroup: &cfg.RecorderRecordingGroupArgs{
 * 				AllSupported:               pulumi.Bool(false),
 * 				IncludeGlobalResourceTypes: pulumi.Bool(false),
 * 				ResourceTypes: pulumi.StringArray{
 * 					pulumi.String("AWS::EC2::Instance"),
 * 					pulumi.String("AWS::EC2::NetworkInterface"),
 * 				},
 * 			},
 * 			RecordingMode: &cfg.RecorderRecordingModeArgs{
 * 				RecordingFrequency: pulumi.String("CONTINUOUS"),
 * 				RecordingModeOverride: &cfg.RecorderRecordingModeRecordingModeOverrideArgs{
 * 					Description: pulumi.String("Only record EC2 network interfaces daily"),
 * 					ResourceTypes: pulumi.StringArray{
 * 						pulumi.String("AWS::EC2::NetworkInterface"),
 * 					},
 * 					RecordingFrequency: pulumi.String("DAILY"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cfg.Recorder;
 * import com.pulumi.aws.cfg.RecorderArgs;
 * import com.pulumi.aws.cfg.inputs.RecorderRecordingGroupArgs;
 * import com.pulumi.aws.cfg.inputs.RecorderRecordingModeArgs;
 * import com.pulumi.aws.cfg.inputs.RecorderRecordingModeRecordingModeOverrideArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Recorder("foo", RecorderArgs.builder()
 *             .name("example")
 *             .roleArn(r.arn())
 *             .recordingGroup(RecorderRecordingGroupArgs.builder()
 *                 .allSupported(false)
 *                 .includeGlobalResourceTypes(false)
 *                 .resourceTypes(
 *                     "AWS::EC2::Instance",
 *                     "AWS::EC2::NetworkInterface")
 *                 .build())
 *             .recordingMode(RecorderRecordingModeArgs.builder()
 *                 .recordingFrequency("CONTINUOUS")
 *                 .recordingModeOverride(RecorderRecordingModeRecordingModeOverrideArgs.builder()
 *                     .description("Only record EC2 network interfaces daily")
 *                     .resourceTypes("AWS::EC2::NetworkInterface")
 *                     .recordingFrequency("DAILY")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:cfg:Recorder
 *     properties:
 *       name: example
 *       roleArn: ${r.arn}
 *       recordingGroup:
 *         allSupported: false
 *         includeGlobalResourceTypes: false
 *         resourceTypes:
 *           - AWS::EC2::Instance
 *           - AWS::EC2::NetworkInterface
 *       recordingMode:
 *         recordingFrequency: CONTINUOUS
 *         recordingModeOverride:
 *           description: Only record EC2 network interfaces daily
 *           resourceTypes:
 *             - AWS::EC2::NetworkInterface
 *           recordingFrequency: DAILY
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Configuration Recorder using the name. For example:
 * ```sh
 * $ pulumi import aws:cfg/recorder:Recorder foo example
 * ```
 */
public class Recorder internal constructor(
    override val javaResource: com.pulumi.aws.cfg.Recorder,
) : KotlinCustomResource(javaResource, RecorderMapper) {
    /**
     * The name of the recorder. Defaults to `default`. Changing it recreates the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Recording group - see below.
     */
    public val recordingGroup: Output<RecorderRecordingGroup>
        get() = javaResource.recordingGroup().applyValue({ args0 ->
            args0.let({ args0 ->
                recorderRecordingGroupToKotlin(args0)
            })
        })

    /**
     * Recording mode - see below.
     */
    public val recordingMode: Output<RecorderRecordingMode>
        get() = javaResource.recordingMode().applyValue({ args0 ->
            args0.let({ args0 ->
                recorderRecordingModeToKotlin(args0)
            })
        })

    /**
     * Amazon Resource Name (ARN) of the IAM role. Used to make read or write requests to the delivery channel and to describe the AWS resources associated with the account. See [AWS Docs](http://docs.aws.amazon.com/config/latest/developerguide/iamrole-permissions.html) for more details.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })
}

public object RecorderMapper : ResourceMapper<Recorder> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cfg.Recorder::class == javaResource::class

    override fun map(javaResource: Resource): Recorder = Recorder(
        javaResource as
            com.pulumi.aws.cfg.Recorder,
    )
}

/**
 * @see [Recorder].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Recorder].
 */
public suspend fun recorder(name: String, block: suspend RecorderResourceBuilder.() -> Unit): Recorder {
    val builder = RecorderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Recorder].
 * @param name The _unique_ name of the resulting resource.
 */
public fun recorder(name: String): Recorder {
    val builder = RecorderResourceBuilder()
    builder.name(name)
    return builder.build()
}
