@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RetentionConfiguration].
 */
@PulumiTagMarker
public class RetentionConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RetentionConfigurationArgs = RetentionConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RetentionConfigurationArgsBuilder.() -> Unit) {
        val builder = RetentionConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RetentionConfiguration {
        val builtJavaResource = com.pulumi.aws.cfg.RetentionConfiguration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RetentionConfiguration(builtJavaResource)
    }
}

/**
 * Provides a resource to manage the AWS Config retention configuration.
 * The retention configuration defines the number of days that AWS Config stores historical information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cfg.RetentionConfiguration("example", {retentionPeriodInDays: 90});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cfg.RetentionConfiguration("example", retention_period_in_days=90)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Cfg.RetentionConfiguration("example", new()
 *     {
 *         RetentionPeriodInDays = 90,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cfg"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cfg.NewRetentionConfiguration(ctx, "example", &cfg.RetentionConfigurationArgs{
 * 			RetentionPeriodInDays: pulumi.Int(90),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cfg.RetentionConfiguration;
 * import com.pulumi.aws.cfg.RetentionConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RetentionConfiguration("example", RetentionConfigurationArgs.builder()
 *             .retentionPeriodInDays(90)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cfg:RetentionConfiguration
 *     properties:
 *       retentionPeriodInDays: 90
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import the AWS Config retention configuration using the `name`. For example:
 * ```sh
 * $ pulumi import aws:cfg/retentionConfiguration:RetentionConfiguration example default
 * ```
 */
public class RetentionConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.cfg.RetentionConfiguration,
) : KotlinCustomResource(javaResource, RetentionConfigurationMapper) {
    /**
     * The name of the retention configuration object. The object is always named **default**.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The number of days AWS Config stores historical information.
     */
    public val retentionPeriodInDays: Output<Int>
        get() = javaResource.retentionPeriodInDays().applyValue({ args0 -> args0 })
}

public object RetentionConfigurationMapper : ResourceMapper<RetentionConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cfg.RetentionConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): RetentionConfiguration =
        RetentionConfiguration(javaResource as com.pulumi.aws.cfg.RetentionConfiguration)
}

/**
 * @see [RetentionConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RetentionConfiguration].
 */
public suspend fun retentionConfiguration(
    name: String,
    block: suspend RetentionConfigurationResourceBuilder.() -> Unit,
): RetentionConfiguration {
    val builder = RetentionConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RetentionConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun retentionConfiguration(name: String): RetentionConfiguration {
    val builder = RetentionConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
