@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin

import com.pulumi.aws.cfg.RetentionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage the AWS Config retention configuration.
 * The retention configuration defines the number of days that AWS Config stores historical information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cfg.RetentionConfiguration("example", {retentionPeriodInDays: 90});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cfg.RetentionConfiguration("example", retention_period_in_days=90)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Cfg.RetentionConfiguration("example", new()
 *     {
 *         RetentionPeriodInDays = 90,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cfg"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cfg.NewRetentionConfiguration(ctx, "example", &cfg.RetentionConfigurationArgs{
 * 			RetentionPeriodInDays: pulumi.Int(90),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cfg.RetentionConfiguration;
 * import com.pulumi.aws.cfg.RetentionConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RetentionConfiguration("example", RetentionConfigurationArgs.builder()
 *             .retentionPeriodInDays(90)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cfg:RetentionConfiguration
 *     properties:
 *       retentionPeriodInDays: 90
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import the AWS Config retention configuration using the `name`. For example:
 * ```sh
 * $ pulumi import aws:cfg/retentionConfiguration:RetentionConfiguration example default
 * ```
 * @property retentionPeriodInDays The number of days AWS Config stores historical information.
 */
public data class RetentionConfigurationArgs(
    public val retentionPeriodInDays: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.RetentionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.cfg.RetentionConfigurationArgs =
        com.pulumi.aws.cfg.RetentionConfigurationArgs.builder()
            .retentionPeriodInDays(retentionPeriodInDays?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RetentionConfigurationArgs].
 */
@PulumiTagMarker
public class RetentionConfigurationArgsBuilder internal constructor() {
    private var retentionPeriodInDays: Output<Int>? = null

    /**
     * @param value The number of days AWS Config stores historical information.
     */
    @JvmName("jxdfixqneywalqmw")
    public suspend fun retentionPeriodInDays(`value`: Output<Int>) {
        this.retentionPeriodInDays = value
    }

    /**
     * @param value The number of days AWS Config stores historical information.
     */
    @JvmName("tjeqmhlwvktovhyn")
    public suspend fun retentionPeriodInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPeriodInDays = mapped
    }

    internal fun build(): RetentionConfigurationArgs = RetentionConfigurationArgs(
        retentionPeriodInDays = retentionPeriodInDays,
    )
}
