@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.inputs

import com.pulumi.aws.cfg.inputs.ConfigurationAggregatorAccountAggregationSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property accountIds List of 12-digit account IDs of the account(s) being aggregated.
 * @property allRegions If true, aggregate existing AWS Config regions and future regions.
 * @property regions List of source regions being aggregated.
 * Either `regions` or `all_regions` (as true) must be specified.
 */
public data class ConfigurationAggregatorAccountAggregationSourceArgs(
    public val accountIds: Output<List<String>>,
    public val allRegions: Output<Boolean>? = null,
    public val regions: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.inputs.ConfigurationAggregatorAccountAggregationSourceArgs> {
    override fun toJava(): com.pulumi.aws.cfg.inputs.ConfigurationAggregatorAccountAggregationSourceArgs =
        com.pulumi.aws.cfg.inputs.ConfigurationAggregatorAccountAggregationSourceArgs.builder()
            .accountIds(accountIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allRegions(allRegions?.applyValue({ args0 -> args0 }))
            .regions(regions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ConfigurationAggregatorAccountAggregationSourceArgs].
 */
@PulumiTagMarker
public class ConfigurationAggregatorAccountAggregationSourceArgsBuilder internal constructor() {
    private var accountIds: Output<List<String>>? = null

    private var allRegions: Output<Boolean>? = null

    private var regions: Output<List<String>>? = null

    /**
     * @param value List of 12-digit account IDs of the account(s) being aggregated.
     */
    @JvmName("iexvidkfobgfycxi")
    public suspend fun accountIds(`value`: Output<List<String>>) {
        this.accountIds = value
    }

    @JvmName("fffytnhoixhooqbm")
    public suspend fun accountIds(vararg values: Output<String>) {
        this.accountIds = Output.all(values.asList())
    }

    /**
     * @param values List of 12-digit account IDs of the account(s) being aggregated.
     */
    @JvmName("wbipannpbqfabbtm")
    public suspend fun accountIds(values: List<Output<String>>) {
        this.accountIds = Output.all(values)
    }

    /**
     * @param value If true, aggregate existing AWS Config regions and future regions.
     */
    @JvmName("jnxjigcabedgcykp")
    public suspend fun allRegions(`value`: Output<Boolean>) {
        this.allRegions = value
    }

    /**
     * @param value List of source regions being aggregated.
     * Either `regions` or `all_regions` (as true) must be specified.
     */
    @JvmName("vqxhfryikmneikdy")
    public suspend fun regions(`value`: Output<List<String>>) {
        this.regions = value
    }

    @JvmName("oyvssgvabpkrprim")
    public suspend fun regions(vararg values: Output<String>) {
        this.regions = Output.all(values.asList())
    }

    /**
     * @param values List of source regions being aggregated.
     * Either `regions` or `all_regions` (as true) must be specified.
     */
    @JvmName("botgeipiavkbvpic")
    public suspend fun regions(values: List<Output<String>>) {
        this.regions = Output.all(values)
    }

    /**
     * @param value List of 12-digit account IDs of the account(s) being aggregated.
     */
    @JvmName("yqcjbqyeeftxwfmo")
    public suspend fun accountIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountIds = mapped
    }

    /**
     * @param values List of 12-digit account IDs of the account(s) being aggregated.
     */
    @JvmName("cpkwriqeqgfiqdsr")
    public suspend fun accountIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountIds = mapped
    }

    /**
     * @param value If true, aggregate existing AWS Config regions and future regions.
     */
    @JvmName("uptpouxttrabrqhx")
    public suspend fun allRegions(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allRegions = mapped
    }

    /**
     * @param value List of source regions being aggregated.
     * Either `regions` or `all_regions` (as true) must be specified.
     */
    @JvmName("jaeoajcalyyjgugh")
    public suspend fun regions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param values List of source regions being aggregated.
     * Either `regions` or `all_regions` (as true) must be specified.
     */
    @JvmName("eryesovhemenvmjb")
    public suspend fun regions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    internal fun build(): ConfigurationAggregatorAccountAggregationSourceArgs =
        ConfigurationAggregatorAccountAggregationSourceArgs(
            accountIds = accountIds ?: throw PulumiNullFieldException("accountIds"),
            allRegions = allRegions,
            regions = regions,
        )
}
