@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.inputs

import com.pulumi.aws.cfg.inputs.ConfigurationAggregatorOrganizationAggregationSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allRegions If true, aggregate existing AWS Config regions and future regions.
 * @property regions List of source regions being aggregated.
 * @property roleArn ARN of the IAM role used to retrieve AWS Organization details associated with the aggregator account.
 * Either `regions` or `all_regions` (as true) must be specified.
 */
public data class ConfigurationAggregatorOrganizationAggregationSourceArgs(
    public val allRegions: Output<Boolean>? = null,
    public val regions: Output<List<String>>? = null,
    public val roleArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.cfg.inputs.ConfigurationAggregatorOrganizationAggregationSourceArgs> {
    override fun toJava(): com.pulumi.aws.cfg.inputs.ConfigurationAggregatorOrganizationAggregationSourceArgs =
        com.pulumi.aws.cfg.inputs.ConfigurationAggregatorOrganizationAggregationSourceArgs.builder()
            .allRegions(allRegions?.applyValue({ args0 -> args0 }))
            .regions(regions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationAggregatorOrganizationAggregationSourceArgs].
 */
@PulumiTagMarker
public class ConfigurationAggregatorOrganizationAggregationSourceArgsBuilder internal constructor() {
    private var allRegions: Output<Boolean>? = null

    private var regions: Output<List<String>>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value If true, aggregate existing AWS Config regions and future regions.
     */
    @JvmName("vqvuhhrkhpqbtlgw")
    public suspend fun allRegions(`value`: Output<Boolean>) {
        this.allRegions = value
    }

    /**
     * @param value List of source regions being aggregated.
     */
    @JvmName("owkexvxdwkmqtefi")
    public suspend fun regions(`value`: Output<List<String>>) {
        this.regions = value
    }

    @JvmName("clbriktkdrslmsho")
    public suspend fun regions(vararg values: Output<String>) {
        this.regions = Output.all(values.asList())
    }

    /**
     * @param values List of source regions being aggregated.
     */
    @JvmName("xwoqjvepfqfwxkdg")
    public suspend fun regions(values: List<Output<String>>) {
        this.regions = Output.all(values)
    }

    /**
     * @param value ARN of the IAM role used to retrieve AWS Organization details associated with the aggregator account.
     * Either `regions` or `all_regions` (as true) must be specified.
     */
    @JvmName("ckhbdikdadnpentg")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value If true, aggregate existing AWS Config regions and future regions.
     */
    @JvmName("fsrigirdsrkrehtm")
    public suspend fun allRegions(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allRegions = mapped
    }

    /**
     * @param value List of source regions being aggregated.
     */
    @JvmName("friwrsjuuavgobio")
    public suspend fun regions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param values List of source regions being aggregated.
     */
    @JvmName("qkngdbmitbuhbgan")
    public suspend fun regions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param value ARN of the IAM role used to retrieve AWS Organization details associated with the aggregator account.
     * Either `regions` or `all_regions` (as true) must be specified.
     */
    @JvmName("mvlfcplxrardmbdt")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): ConfigurationAggregatorOrganizationAggregationSourceArgs =
        ConfigurationAggregatorOrganizationAggregationSourceArgs(
            allRegions = allRegions,
            regions = regions,
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        )
}
