@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.inputs

import com.pulumi.aws.cfg.inputs.ConformancePackInputParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property parameterName The input key.
 * @property parameterValue The input value.
 */
public data class ConformancePackInputParameterArgs(
    public val parameterName: Output<String>,
    public val parameterValue: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cfg.inputs.ConformancePackInputParameterArgs> {
    override fun toJava(): com.pulumi.aws.cfg.inputs.ConformancePackInputParameterArgs =
        com.pulumi.aws.cfg.inputs.ConformancePackInputParameterArgs.builder()
            .parameterName(parameterName.applyValue({ args0 -> args0 }))
            .parameterValue(parameterValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConformancePackInputParameterArgs].
 */
@PulumiTagMarker
public class ConformancePackInputParameterArgsBuilder internal constructor() {
    private var parameterName: Output<String>? = null

    private var parameterValue: Output<String>? = null

    /**
     * @param value The input key.
     */
    @JvmName("uhfawxqxqscopsed")
    public suspend fun parameterName(`value`: Output<String>) {
        this.parameterName = value
    }

    /**
     * @param value The input value.
     */
    @JvmName("hipqjctjwdgbrqot")
    public suspend fun parameterValue(`value`: Output<String>) {
        this.parameterValue = value
    }

    /**
     * @param value The input key.
     */
    @JvmName("piutnqmgpaxerwge")
    public suspend fun parameterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameterName = mapped
    }

    /**
     * @param value The input value.
     */
    @JvmName("bwkxqooonyyxcqdx")
    public suspend fun parameterValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameterValue = mapped
    }

    internal fun build(): ConformancePackInputParameterArgs = ConformancePackInputParameterArgs(
        parameterName = parameterName ?: throw PulumiNullFieldException("parameterName"),
        parameterValue = parameterValue ?: throw PulumiNullFieldException("parameterValue"),
    )
}
