@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.inputs

import com.pulumi.aws.cfg.inputs.DeliveryChannelSnapshotDeliveryPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deliveryFrequency The frequency with which AWS Config recurringly delivers configuration snapshotsE.g., `One_Hour` or `Three_Hours`. Valid values are listed [here](https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigSnapshotDeliveryProperties.html#API_ConfigSnapshotDeliveryProperties_Contents).
 */
public data class DeliveryChannelSnapshotDeliveryPropertiesArgs(
    public val deliveryFrequency: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.inputs.DeliveryChannelSnapshotDeliveryPropertiesArgs> {
    override fun toJava(): com.pulumi.aws.cfg.inputs.DeliveryChannelSnapshotDeliveryPropertiesArgs =
        com.pulumi.aws.cfg.inputs.DeliveryChannelSnapshotDeliveryPropertiesArgs.builder()
            .deliveryFrequency(deliveryFrequency?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeliveryChannelSnapshotDeliveryPropertiesArgs].
 */
@PulumiTagMarker
public class DeliveryChannelSnapshotDeliveryPropertiesArgsBuilder internal constructor() {
    private var deliveryFrequency: Output<String>? = null

    /**
     * @param value The frequency with which AWS Config recurringly delivers configuration snapshotsE.g., `One_Hour` or `Three_Hours`. Valid values are listed [here](https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigSnapshotDeliveryProperties.html#API_ConfigSnapshotDeliveryProperties_Contents).
     */
    @JvmName("osjctykfubauvwue")
    public suspend fun deliveryFrequency(`value`: Output<String>) {
        this.deliveryFrequency = value
    }

    /**
     * @param value The frequency with which AWS Config recurringly delivers configuration snapshotsE.g., `One_Hour` or `Three_Hours`. Valid values are listed [here](https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigSnapshotDeliveryProperties.html#API_ConfigSnapshotDeliveryProperties_Contents).
     */
    @JvmName("cukmiqyqqoyfdsjd")
    public suspend fun deliveryFrequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryFrequency = mapped
    }

    internal fun build(): DeliveryChannelSnapshotDeliveryPropertiesArgs =
        DeliveryChannelSnapshotDeliveryPropertiesArgs(
            deliveryFrequency = deliveryFrequency,
        )
}
