@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.inputs

import com.pulumi.aws.cfg.inputs.RecorderRecordingGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allSupported Specifies whether AWS Config records configuration changes for every supported type of regional resource (which includes any new type that will become supported in the future). Conflicts with `resource_types`. Defaults to `true`.
 * @property exclusionByResourceTypes An object that specifies how AWS Config excludes resource types from being recorded by the configuration recorder.To use this option, you must set the useOnly field of RecordingStrategy to `EXCLUSION_BY_RESOURCE_TYPES` Requires `all_supported = false`. Conflicts with `resource_types`.
 * @property includeGlobalResourceTypes Specifies whether AWS Config includes all supported types of _global resources_ with the resources that it records. Requires `all_supported = true`. Conflicts with `resource_types`.
 * @property recordingStrategies Recording Strategy. Detailed below.
 * @property resourceTypes A list that specifies the types of AWS resources for which AWS Config records configuration changes (for example, `AWS::EC2::Instance` or `AWS::CloudTrail::Trail`). See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types. In order to use this attribute, `all_supported` must be set to false.
 */
public data class RecorderRecordingGroupArgs(
    public val allSupported: Output<Boolean>? = null,
    public val exclusionByResourceTypes: Output<List<RecorderRecordingGroupExclusionByResourceTypeArgs>>? = null,
    public val includeGlobalResourceTypes: Output<Boolean>? = null,
    public val recordingStrategies: Output<List<RecorderRecordingGroupRecordingStrategyArgs>>? = null,
    public val resourceTypes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.inputs.RecorderRecordingGroupArgs> {
    override fun toJava(): com.pulumi.aws.cfg.inputs.RecorderRecordingGroupArgs =
        com.pulumi.aws.cfg.inputs.RecorderRecordingGroupArgs.builder()
            .allSupported(allSupported?.applyValue({ args0 -> args0 }))
            .exclusionByResourceTypes(
                exclusionByResourceTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .includeGlobalResourceTypes(includeGlobalResourceTypes?.applyValue({ args0 -> args0 }))
            .recordingStrategies(
                recordingStrategies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceTypes(resourceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RecorderRecordingGroupArgs].
 */
@PulumiTagMarker
public class RecorderRecordingGroupArgsBuilder internal constructor() {
    private var allSupported: Output<Boolean>? = null

    private var exclusionByResourceTypes:
        Output<List<RecorderRecordingGroupExclusionByResourceTypeArgs>>? = null

    private var includeGlobalResourceTypes: Output<Boolean>? = null

    private var recordingStrategies: Output<List<RecorderRecordingGroupRecordingStrategyArgs>>? = null

    private var resourceTypes: Output<List<String>>? = null

    /**
     * @param value Specifies whether AWS Config records configuration changes for every supported type of regional resource (which includes any new type that will become supported in the future). Conflicts with `resource_types`. Defaults to `true`.
     */
    @JvmName("spkafkxfmotyjswp")
    public suspend fun allSupported(`value`: Output<Boolean>) {
        this.allSupported = value
    }

    /**
     * @param value An object that specifies how AWS Config excludes resource types from being recorded by the configuration recorder.To use this option, you must set the useOnly field of RecordingStrategy to `EXCLUSION_BY_RESOURCE_TYPES` Requires `all_supported = false`. Conflicts with `resource_types`.
     */
    @JvmName("snuscjpkunapdauw")
    public suspend fun exclusionByResourceTypes(`value`: Output<List<RecorderRecordingGroupExclusionByResourceTypeArgs>>) {
        this.exclusionByResourceTypes = value
    }

    @JvmName("svhaheliiqesrifl")
    public suspend fun exclusionByResourceTypes(vararg values: Output<RecorderRecordingGroupExclusionByResourceTypeArgs>) {
        this.exclusionByResourceTypes = Output.all(values.asList())
    }

    /**
     * @param values An object that specifies how AWS Config excludes resource types from being recorded by the configuration recorder.To use this option, you must set the useOnly field of RecordingStrategy to `EXCLUSION_BY_RESOURCE_TYPES` Requires `all_supported = false`. Conflicts with `resource_types`.
     */
    @JvmName("lhqvplwdsevmrmne")
    public suspend fun exclusionByResourceTypes(values: List<Output<RecorderRecordingGroupExclusionByResourceTypeArgs>>) {
        this.exclusionByResourceTypes = Output.all(values)
    }

    /**
     * @param value Specifies whether AWS Config includes all supported types of _global resources_ with the resources that it records. Requires `all_supported = true`. Conflicts with `resource_types`.
     */
    @JvmName("tffsmhpaecupdvcs")
    public suspend fun includeGlobalResourceTypes(`value`: Output<Boolean>) {
        this.includeGlobalResourceTypes = value
    }

    /**
     * @param value Recording Strategy. Detailed below.
     */
    @JvmName("txiojfmvtatppkle")
    public suspend fun recordingStrategies(`value`: Output<List<RecorderRecordingGroupRecordingStrategyArgs>>) {
        this.recordingStrategies = value
    }

    @JvmName("wykhuufkwsggftwp")
    public suspend fun recordingStrategies(vararg values: Output<RecorderRecordingGroupRecordingStrategyArgs>) {
        this.recordingStrategies = Output.all(values.asList())
    }

    /**
     * @param values Recording Strategy. Detailed below.
     */
    @JvmName("havqhkvqrvgkcukc")
    public suspend fun recordingStrategies(values: List<Output<RecorderRecordingGroupRecordingStrategyArgs>>) {
        this.recordingStrategies = Output.all(values)
    }

    /**
     * @param value A list that specifies the types of AWS resources for which AWS Config records configuration changes (for example, `AWS::EC2::Instance` or `AWS::CloudTrail::Trail`). See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types. In order to use this attribute, `all_supported` must be set to false.
     */
    @JvmName("jvmtsweuggippawv")
    public suspend fun resourceTypes(`value`: Output<List<String>>) {
        this.resourceTypes = value
    }

    @JvmName("phnhteyscjmvivqu")
    public suspend fun resourceTypes(vararg values: Output<String>) {
        this.resourceTypes = Output.all(values.asList())
    }

    /**
     * @param values A list that specifies the types of AWS resources for which AWS Config records configuration changes (for example, `AWS::EC2::Instance` or `AWS::CloudTrail::Trail`). See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types. In order to use this attribute, `all_supported` must be set to false.
     */
    @JvmName("qonhlayeymnqusta")
    public suspend fun resourceTypes(values: List<Output<String>>) {
        this.resourceTypes = Output.all(values)
    }

    /**
     * @param value Specifies whether AWS Config records configuration changes for every supported type of regional resource (which includes any new type that will become supported in the future). Conflicts with `resource_types`. Defaults to `true`.
     */
    @JvmName("ncqmxkkcerpvixmk")
    public suspend fun allSupported(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allSupported = mapped
    }

    /**
     * @param value An object that specifies how AWS Config excludes resource types from being recorded by the configuration recorder.To use this option, you must set the useOnly field of RecordingStrategy to `EXCLUSION_BY_RESOURCE_TYPES` Requires `all_supported = false`. Conflicts with `resource_types`.
     */
    @JvmName("pyclbeendqhjgxiy")
    public suspend fun exclusionByResourceTypes(`value`: List<RecorderRecordingGroupExclusionByResourceTypeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusionByResourceTypes = mapped
    }

    /**
     * @param argument An object that specifies how AWS Config excludes resource types from being recorded by the configuration recorder.To use this option, you must set the useOnly field of RecordingStrategy to `EXCLUSION_BY_RESOURCE_TYPES` Requires `all_supported = false`. Conflicts with `resource_types`.
     */
    @JvmName("aljhjrobtpjhoydr")
    public suspend fun exclusionByResourceTypes(argument: List<suspend RecorderRecordingGroupExclusionByResourceTypeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RecorderRecordingGroupExclusionByResourceTypeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.exclusionByResourceTypes = mapped
    }

    /**
     * @param argument An object that specifies how AWS Config excludes resource types from being recorded by the configuration recorder.To use this option, you must set the useOnly field of RecordingStrategy to `EXCLUSION_BY_RESOURCE_TYPES` Requires `all_supported = false`. Conflicts with `resource_types`.
     */
    @JvmName("riaxeudcdinwvedf")
    public suspend fun exclusionByResourceTypes(vararg argument: suspend RecorderRecordingGroupExclusionByResourceTypeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RecorderRecordingGroupExclusionByResourceTypeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.exclusionByResourceTypes = mapped
    }

    /**
     * @param argument An object that specifies how AWS Config excludes resource types from being recorded by the configuration recorder.To use this option, you must set the useOnly field of RecordingStrategy to `EXCLUSION_BY_RESOURCE_TYPES` Requires `all_supported = false`. Conflicts with `resource_types`.
     */
    @JvmName("ljlrbhraitqeliol")
    public suspend fun exclusionByResourceTypes(argument: suspend RecorderRecordingGroupExclusionByResourceTypeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RecorderRecordingGroupExclusionByResourceTypeArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.exclusionByResourceTypes = mapped
    }

    /**
     * @param values An object that specifies how AWS Config excludes resource types from being recorded by the configuration recorder.To use this option, you must set the useOnly field of RecordingStrategy to `EXCLUSION_BY_RESOURCE_TYPES` Requires `all_supported = false`. Conflicts with `resource_types`.
     */
    @JvmName("jrfmfpgrkismrekl")
    public suspend fun exclusionByResourceTypes(vararg values: RecorderRecordingGroupExclusionByResourceTypeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exclusionByResourceTypes = mapped
    }

    /**
     * @param value Specifies whether AWS Config includes all supported types of _global resources_ with the resources that it records. Requires `all_supported = true`. Conflicts with `resource_types`.
     */
    @JvmName("lmecardobinjpchs")
    public suspend fun includeGlobalResourceTypes(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeGlobalResourceTypes = mapped
    }

    /**
     * @param value Recording Strategy. Detailed below.
     */
    @JvmName("wvxlknywibuvxqyw")
    public suspend fun recordingStrategies(`value`: List<RecorderRecordingGroupRecordingStrategyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordingStrategies = mapped
    }

    /**
     * @param argument Recording Strategy. Detailed below.
     */
    @JvmName("khmbwqbcxokabccr")
    public suspend fun recordingStrategies(argument: List<suspend RecorderRecordingGroupRecordingStrategyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RecorderRecordingGroupRecordingStrategyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.recordingStrategies = mapped
    }

    /**
     * @param argument Recording Strategy. Detailed below.
     */
    @JvmName("pxifydixmvdcqxff")
    public suspend fun recordingStrategies(vararg argument: suspend RecorderRecordingGroupRecordingStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RecorderRecordingGroupRecordingStrategyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.recordingStrategies = mapped
    }

    /**
     * @param argument Recording Strategy. Detailed below.
     */
    @JvmName("wciljvvrfhfpttin")
    public suspend fun recordingStrategies(argument: suspend RecorderRecordingGroupRecordingStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RecorderRecordingGroupRecordingStrategyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.recordingStrategies = mapped
    }

    /**
     * @param values Recording Strategy. Detailed below.
     */
    @JvmName("yqbghlvybwpleglq")
    public suspend fun recordingStrategies(vararg values: RecorderRecordingGroupRecordingStrategyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordingStrategies = mapped
    }

    /**
     * @param value A list that specifies the types of AWS resources for which AWS Config records configuration changes (for example, `AWS::EC2::Instance` or `AWS::CloudTrail::Trail`). See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types. In order to use this attribute, `all_supported` must be set to false.
     */
    @JvmName("kuqngrkshethqonq")
    public suspend fun resourceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param values A list that specifies the types of AWS resources for which AWS Config records configuration changes (for example, `AWS::EC2::Instance` or `AWS::CloudTrail::Trail`). See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types. In order to use this attribute, `all_supported` must be set to false.
     */
    @JvmName("stpufmxtyoevkopj")
    public suspend fun resourceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    internal fun build(): RecorderRecordingGroupArgs = RecorderRecordingGroupArgs(
        allSupported = allSupported,
        exclusionByResourceTypes = exclusionByResourceTypes,
        includeGlobalResourceTypes = includeGlobalResourceTypes,
        recordingStrategies = recordingStrategies,
        resourceTypes = resourceTypes,
    )
}
