@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.inputs

import com.pulumi.aws.cfg.inputs.RecorderRecordingGroupExclusionByResourceTypeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property resourceTypes A list that specifies the types of AWS resources for which AWS Config excludes records configuration changes. See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types.
 */
public data class RecorderRecordingGroupExclusionByResourceTypeArgs(
    public val resourceTypes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.inputs.RecorderRecordingGroupExclusionByResourceTypeArgs> {
    override fun toJava(): com.pulumi.aws.cfg.inputs.RecorderRecordingGroupExclusionByResourceTypeArgs = com.pulumi.aws.cfg.inputs.RecorderRecordingGroupExclusionByResourceTypeArgs.builder()
        .resourceTypes(resourceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RecorderRecordingGroupExclusionByResourceTypeArgs].
 */
@PulumiTagMarker
public class RecorderRecordingGroupExclusionByResourceTypeArgsBuilder internal constructor() {
    private var resourceTypes: Output<List<String>>? = null

    /**
     * @param value A list that specifies the types of AWS resources for which AWS Config excludes records configuration changes. See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types.
     */
    @JvmName("fprmjfhnpjnvwafy")
    public suspend fun resourceTypes(`value`: Output<List<String>>) {
        this.resourceTypes = value
    }

    @JvmName("orlgvinsiqneubbo")
    public suspend fun resourceTypes(vararg values: Output<String>) {
        this.resourceTypes = Output.all(values.asList())
    }

    /**
     * @param values A list that specifies the types of AWS resources for which AWS Config excludes records configuration changes. See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types.
     */
    @JvmName("gwfvhrbjodxaufff")
    public suspend fun resourceTypes(values: List<Output<String>>) {
        this.resourceTypes = Output.all(values)
    }

    /**
     * @param value A list that specifies the types of AWS resources for which AWS Config excludes records configuration changes. See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types.
     */
    @JvmName("maldbcdbglyldnpl")
    public suspend fun resourceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param values A list that specifies the types of AWS resources for which AWS Config excludes records configuration changes. See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types.
     */
    @JvmName("opccjbkghrurscab")
    public suspend fun resourceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    internal fun build(): RecorderRecordingGroupExclusionByResourceTypeArgs =
        RecorderRecordingGroupExclusionByResourceTypeArgs(
            resourceTypes = resourceTypes,
        )
}
