@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.inputs

import com.pulumi.aws.cfg.inputs.RecorderRecordingModeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property recordingFrequency Default reecording frequency. `CONTINUOUS` or `DAILY`.
 * @property recordingModeOverride Recording mode overrides. Detailed below.
 */
public data class RecorderRecordingModeArgs(
    public val recordingFrequency: Output<String>? = null,
    public val recordingModeOverride: Output<RecorderRecordingModeRecordingModeOverrideArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.inputs.RecorderRecordingModeArgs> {
    override fun toJava(): com.pulumi.aws.cfg.inputs.RecorderRecordingModeArgs =
        com.pulumi.aws.cfg.inputs.RecorderRecordingModeArgs.builder()
            .recordingFrequency(recordingFrequency?.applyValue({ args0 -> args0 }))
            .recordingModeOverride(
                recordingModeOverride?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RecorderRecordingModeArgs].
 */
@PulumiTagMarker
public class RecorderRecordingModeArgsBuilder internal constructor() {
    private var recordingFrequency: Output<String>? = null

    private var recordingModeOverride: Output<RecorderRecordingModeRecordingModeOverrideArgs>? = null

    /**
     * @param value Default reecording frequency. `CONTINUOUS` or `DAILY`.
     */
    @JvmName("nxbovovfdsceoigl")
    public suspend fun recordingFrequency(`value`: Output<String>) {
        this.recordingFrequency = value
    }

    /**
     * @param value Recording mode overrides. Detailed below.
     */
    @JvmName("hnqolpvowttxwcio")
    public suspend fun recordingModeOverride(`value`: Output<RecorderRecordingModeRecordingModeOverrideArgs>) {
        this.recordingModeOverride = value
    }

    /**
     * @param value Default reecording frequency. `CONTINUOUS` or `DAILY`.
     */
    @JvmName("wdlsrdqacnsnqkmd")
    public suspend fun recordingFrequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordingFrequency = mapped
    }

    /**
     * @param value Recording mode overrides. Detailed below.
     */
    @JvmName("loapqmubsckpkqcm")
    public suspend fun recordingModeOverride(`value`: RecorderRecordingModeRecordingModeOverrideArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordingModeOverride = mapped
    }

    /**
     * @param argument Recording mode overrides. Detailed below.
     */
    @JvmName("oepeforataahfcxm")
    public suspend fun recordingModeOverride(argument: suspend RecorderRecordingModeRecordingModeOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = RecorderRecordingModeRecordingModeOverrideArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.recordingModeOverride = mapped
    }

    internal fun build(): RecorderRecordingModeArgs = RecorderRecordingModeArgs(
        recordingFrequency = recordingFrequency,
        recordingModeOverride = recordingModeOverride,
    )
}
