@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.inputs

import com.pulumi.aws.cfg.inputs.RecorderRecordingModeRecordingModeOverrideArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property description A description you provide of the override.
 * @property recordingFrequency The recording frequency for the resources in the override block. `CONTINUOUS` or `DAILY`.
 * @property resourceTypes A list that specifies the types of AWS resources for which the override applies to.  See [restrictions in the AWS Docs](https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingModeOverride.html)
 */
public data class RecorderRecordingModeRecordingModeOverrideArgs(
    public val description: Output<String>? = null,
    public val recordingFrequency: Output<String>,
    public val resourceTypes: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.cfg.inputs.RecorderRecordingModeRecordingModeOverrideArgs> {
    override fun toJava(): com.pulumi.aws.cfg.inputs.RecorderRecordingModeRecordingModeOverrideArgs =
        com.pulumi.aws.cfg.inputs.RecorderRecordingModeRecordingModeOverrideArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .recordingFrequency(recordingFrequency.applyValue({ args0 -> args0 }))
            .resourceTypes(resourceTypes.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RecorderRecordingModeRecordingModeOverrideArgs].
 */
@PulumiTagMarker
public class RecorderRecordingModeRecordingModeOverrideArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var recordingFrequency: Output<String>? = null

    private var resourceTypes: Output<List<String>>? = null

    /**
     * @param value A description you provide of the override.
     */
    @JvmName("voppfdhmkgjwspyi")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The recording frequency for the resources in the override block. `CONTINUOUS` or `DAILY`.
     */
    @JvmName("myroqtnxskkurvwr")
    public suspend fun recordingFrequency(`value`: Output<String>) {
        this.recordingFrequency = value
    }

    /**
     * @param value A list that specifies the types of AWS resources for which the override applies to.  See [restrictions in the AWS Docs](https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingModeOverride.html)
     */
    @JvmName("wxftxheqmetwxehk")
    public suspend fun resourceTypes(`value`: Output<List<String>>) {
        this.resourceTypes = value
    }

    @JvmName("xvlighqaymiqgcxj")
    public suspend fun resourceTypes(vararg values: Output<String>) {
        this.resourceTypes = Output.all(values.asList())
    }

    /**
     * @param values A list that specifies the types of AWS resources for which the override applies to.  See [restrictions in the AWS Docs](https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingModeOverride.html)
     */
    @JvmName("aecbycyamcdrdkkm")
    public suspend fun resourceTypes(values: List<Output<String>>) {
        this.resourceTypes = Output.all(values)
    }

    /**
     * @param value A description you provide of the override.
     */
    @JvmName("dcndlbwmdliaeenf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The recording frequency for the resources in the override block. `CONTINUOUS` or `DAILY`.
     */
    @JvmName("htfnxsixnpurbxgn")
    public suspend fun recordingFrequency(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordingFrequency = mapped
    }

    /**
     * @param value A list that specifies the types of AWS resources for which the override applies to.  See [restrictions in the AWS Docs](https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingModeOverride.html)
     */
    @JvmName("tqsvcayewgomajkt")
    public suspend fun resourceTypes(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param values A list that specifies the types of AWS resources for which the override applies to.  See [restrictions in the AWS Docs](https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingModeOverride.html)
     */
    @JvmName("yeuurtkqxvmynqai")
    public suspend fun resourceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    internal fun build(): RecorderRecordingModeRecordingModeOverrideArgs =
        RecorderRecordingModeRecordingModeOverrideArgs(
            description = description,
            recordingFrequency = recordingFrequency ?: throw PulumiNullFieldException("recordingFrequency"),
            resourceTypes = resourceTypes ?: throw PulumiNullFieldException("resourceTypes"),
        )
}
