@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.inputs

import com.pulumi.aws.cfg.inputs.RemediationConfigurationExecutionControlsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property ssmControls Configuration block for SSM controls. See below.
 */
public data class RemediationConfigurationExecutionControlsArgs(
    public val ssmControls: Output<RemediationConfigurationExecutionControlsSsmControlsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.inputs.RemediationConfigurationExecutionControlsArgs> {
    override fun toJava(): com.pulumi.aws.cfg.inputs.RemediationConfigurationExecutionControlsArgs =
        com.pulumi.aws.cfg.inputs.RemediationConfigurationExecutionControlsArgs.builder()
            .ssmControls(ssmControls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RemediationConfigurationExecutionControlsArgs].
 */
@PulumiTagMarker
public class RemediationConfigurationExecutionControlsArgsBuilder internal constructor() {
    private var ssmControls: Output<RemediationConfigurationExecutionControlsSsmControlsArgs>? = null

    /**
     * @param value Configuration block for SSM controls. See below.
     */
    @JvmName("orwbniiithifljjh")
    public suspend fun ssmControls(`value`: Output<RemediationConfigurationExecutionControlsSsmControlsArgs>) {
        this.ssmControls = value
    }

    /**
     * @param value Configuration block for SSM controls. See below.
     */
    @JvmName("ttlbjwbbqvqrmaew")
    public suspend fun ssmControls(`value`: RemediationConfigurationExecutionControlsSsmControlsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssmControls = mapped
    }

    /**
     * @param argument Configuration block for SSM controls. See below.
     */
    @JvmName("quxaenkwqurmbgaj")
    public suspend fun ssmControls(argument: suspend RemediationConfigurationExecutionControlsSsmControlsArgsBuilder.() -> Unit) {
        val toBeMapped = RemediationConfigurationExecutionControlsSsmControlsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ssmControls = mapped
    }

    internal fun build(): RemediationConfigurationExecutionControlsArgs =
        RemediationConfigurationExecutionControlsArgs(
            ssmControls = ssmControls,
        )
}
