@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.inputs

import com.pulumi.aws.cfg.inputs.RemediationConfigurationExecutionControlsSsmControlsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property concurrentExecutionRatePercentage Maximum percentage of remediation actions allowed to run in parallel on the non-compliant resources for that specific rule. The default value is 10%.
 * @property errorPercentage Percentage of errors that are allowed before SSM stops running automations on non-compliant resources for that specific rule. The default is 50%.
 */
public data class RemediationConfigurationExecutionControlsSsmControlsArgs(
    public val concurrentExecutionRatePercentage: Output<Int>? = null,
    public val errorPercentage: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cfg.inputs.RemediationConfigurationExecutionControlsSsmControlsArgs> {
    override fun toJava(): com.pulumi.aws.cfg.inputs.RemediationConfigurationExecutionControlsSsmControlsArgs =
        com.pulumi.aws.cfg.inputs.RemediationConfigurationExecutionControlsSsmControlsArgs.builder()
            .concurrentExecutionRatePercentage(
                concurrentExecutionRatePercentage?.applyValue({ args0 ->
                    args0
                }),
            )
            .errorPercentage(errorPercentage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RemediationConfigurationExecutionControlsSsmControlsArgs].
 */
@PulumiTagMarker
public class RemediationConfigurationExecutionControlsSsmControlsArgsBuilder internal constructor() {
    private var concurrentExecutionRatePercentage: Output<Int>? = null

    private var errorPercentage: Output<Int>? = null

    /**
     * @param value Maximum percentage of remediation actions allowed to run in parallel on the non-compliant resources for that specific rule. The default value is 10%.
     */
    @JvmName("msagvtgdfvwoybde")
    public suspend fun concurrentExecutionRatePercentage(`value`: Output<Int>) {
        this.concurrentExecutionRatePercentage = value
    }

    /**
     * @param value Percentage of errors that are allowed before SSM stops running automations on non-compliant resources for that specific rule. The default is 50%.
     */
    @JvmName("ptxafmyardwiiufh")
    public suspend fun errorPercentage(`value`: Output<Int>) {
        this.errorPercentage = value
    }

    /**
     * @param value Maximum percentage of remediation actions allowed to run in parallel on the non-compliant resources for that specific rule. The default value is 10%.
     */
    @JvmName("jrjdnqoqmlkmpppg")
    public suspend fun concurrentExecutionRatePercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.concurrentExecutionRatePercentage = mapped
    }

    /**
     * @param value Percentage of errors that are allowed before SSM stops running automations on non-compliant resources for that specific rule. The default is 50%.
     */
    @JvmName("gvfsqdaypnhywsds")
    public suspend fun errorPercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorPercentage = mapped
    }

    internal fun build(): RemediationConfigurationExecutionControlsSsmControlsArgs =
        RemediationConfigurationExecutionControlsSsmControlsArgs(
            concurrentExecutionRatePercentage = concurrentExecutionRatePercentage,
            errorPercentage = errorPercentage,
        )
}
