@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.inputs

import com.pulumi.aws.cfg.inputs.RemediationConfigurationParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the attribute.
 * @property resourceValue Value is dynamic and changes at run-time.
 * @property staticValue Value is static and does not change at run-time.
 * @property staticValues List of static values.
 */
public data class RemediationConfigurationParameterArgs(
    public val name: Output<String>,
    public val resourceValue: Output<String>? = null,
    public val staticValue: Output<String>? = null,
    public val staticValues: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.inputs.RemediationConfigurationParameterArgs> {
    override fun toJava(): com.pulumi.aws.cfg.inputs.RemediationConfigurationParameterArgs =
        com.pulumi.aws.cfg.inputs.RemediationConfigurationParameterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .resourceValue(resourceValue?.applyValue({ args0 -> args0 }))
            .staticValue(staticValue?.applyValue({ args0 -> args0 }))
            .staticValues(staticValues?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RemediationConfigurationParameterArgs].
 */
@PulumiTagMarker
public class RemediationConfigurationParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var resourceValue: Output<String>? = null

    private var staticValue: Output<String>? = null

    private var staticValues: Output<List<String>>? = null

    /**
     * @param value Name of the attribute.
     */
    @JvmName("igaxbyxhtskutjgq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Value is dynamic and changes at run-time.
     */
    @JvmName("gqgwwwladhejqtxm")
    public suspend fun resourceValue(`value`: Output<String>) {
        this.resourceValue = value
    }

    /**
     * @param value Value is static and does not change at run-time.
     */
    @JvmName("ukuyqfhrhuhiqrxt")
    public suspend fun staticValue(`value`: Output<String>) {
        this.staticValue = value
    }

    /**
     * @param value List of static values.
     */
    @JvmName("hlsywrmjrwpxrkfj")
    public suspend fun staticValues(`value`: Output<List<String>>) {
        this.staticValues = value
    }

    @JvmName("heppxfubhosonvoe")
    public suspend fun staticValues(vararg values: Output<String>) {
        this.staticValues = Output.all(values.asList())
    }

    /**
     * @param values List of static values.
     */
    @JvmName("oaegutjpnnrmcmgv")
    public suspend fun staticValues(values: List<Output<String>>) {
        this.staticValues = Output.all(values)
    }

    /**
     * @param value Name of the attribute.
     */
    @JvmName("pxnoxndrgiatekwe")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Value is dynamic and changes at run-time.
     */
    @JvmName("ossjlelibfdxogyy")
    public suspend fun resourceValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceValue = mapped
    }

    /**
     * @param value Value is static and does not change at run-time.
     */
    @JvmName("hrxmqcsojqyedotv")
    public suspend fun staticValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staticValue = mapped
    }

    /**
     * @param value List of static values.
     */
    @JvmName("taqmjqudjycgkjjt")
    public suspend fun staticValues(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staticValues = mapped
    }

    /**
     * @param values List of static values.
     */
    @JvmName("xekdlicfkwcyobwu")
    public suspend fun staticValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.staticValues = mapped
    }

    internal fun build(): RemediationConfigurationParameterArgs =
        RemediationConfigurationParameterArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            resourceValue = resourceValue,
            staticValue = staticValue,
            staticValues = staticValues,
        )
}
