@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.inputs

import com.pulumi.aws.cfg.inputs.RuleScopeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property complianceResourceId The IDs of the only AWS resource that you want to trigger an evaluation for the rule. If you specify a resource ID, you must specify one resource type for `compliance_resource_types`.
 * @property complianceResourceTypes A list of resource types of only those AWS resources that you want to trigger an evaluation for the ruleE.g., `AWS::EC2::Instance`. You can only specify one type if you also specify a resource ID for `compliance_resource_id`. See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types.
 * @property tagKey The tag key that is applied to only those AWS resources that you want you want to trigger an evaluation for the rule.
 * @property tagValue The tag value applied to only those AWS resources that you want to trigger an evaluation for the rule.
 */
public data class RuleScopeArgs(
    public val complianceResourceId: Output<String>? = null,
    public val complianceResourceTypes: Output<List<String>>? = null,
    public val tagKey: Output<String>? = null,
    public val tagValue: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.inputs.RuleScopeArgs> {
    override fun toJava(): com.pulumi.aws.cfg.inputs.RuleScopeArgs =
        com.pulumi.aws.cfg.inputs.RuleScopeArgs.builder()
            .complianceResourceId(complianceResourceId?.applyValue({ args0 -> args0 }))
            .complianceResourceTypes(
                complianceResourceTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .tagKey(tagKey?.applyValue({ args0 -> args0 }))
            .tagValue(tagValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleScopeArgs].
 */
@PulumiTagMarker
public class RuleScopeArgsBuilder internal constructor() {
    private var complianceResourceId: Output<String>? = null

    private var complianceResourceTypes: Output<List<String>>? = null

    private var tagKey: Output<String>? = null

    private var tagValue: Output<String>? = null

    /**
     * @param value The IDs of the only AWS resource that you want to trigger an evaluation for the rule. If you specify a resource ID, you must specify one resource type for `compliance_resource_types`.
     */
    @JvmName("purnowboloqngnur")
    public suspend fun complianceResourceId(`value`: Output<String>) {
        this.complianceResourceId = value
    }

    /**
     * @param value A list of resource types of only those AWS resources that you want to trigger an evaluation for the ruleE.g., `AWS::EC2::Instance`. You can only specify one type if you also specify a resource ID for `compliance_resource_id`. See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types.
     */
    @JvmName("tovegsakublxqlot")
    public suspend fun complianceResourceTypes(`value`: Output<List<String>>) {
        this.complianceResourceTypes = value
    }

    @JvmName("hqmenksnqscifgbq")
    public suspend fun complianceResourceTypes(vararg values: Output<String>) {
        this.complianceResourceTypes = Output.all(values.asList())
    }

    /**
     * @param values A list of resource types of only those AWS resources that you want to trigger an evaluation for the ruleE.g., `AWS::EC2::Instance`. You can only specify one type if you also specify a resource ID for `compliance_resource_id`. See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types.
     */
    @JvmName("xkyeladsarotrxdx")
    public suspend fun complianceResourceTypes(values: List<Output<String>>) {
        this.complianceResourceTypes = Output.all(values)
    }

    /**
     * @param value The tag key that is applied to only those AWS resources that you want you want to trigger an evaluation for the rule.
     */
    @JvmName("mlvkhfvflkfhjggr")
    public suspend fun tagKey(`value`: Output<String>) {
        this.tagKey = value
    }

    /**
     * @param value The tag value applied to only those AWS resources that you want to trigger an evaluation for the rule.
     */
    @JvmName("ebeqjoqpsaeknhnt")
    public suspend fun tagValue(`value`: Output<String>) {
        this.tagValue = value
    }

    /**
     * @param value The IDs of the only AWS resource that you want to trigger an evaluation for the rule. If you specify a resource ID, you must specify one resource type for `compliance_resource_types`.
     */
    @JvmName("mlwfwmrmeslvkggs")
    public suspend fun complianceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.complianceResourceId = mapped
    }

    /**
     * @param value A list of resource types of only those AWS resources that you want to trigger an evaluation for the ruleE.g., `AWS::EC2::Instance`. You can only specify one type if you also specify a resource ID for `compliance_resource_id`. See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types.
     */
    @JvmName("jhfltsaapfniqjgx")
    public suspend fun complianceResourceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.complianceResourceTypes = mapped
    }

    /**
     * @param values A list of resource types of only those AWS resources that you want to trigger an evaluation for the ruleE.g., `AWS::EC2::Instance`. You can only specify one type if you also specify a resource ID for `compliance_resource_id`. See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types.
     */
    @JvmName("xucwhnkvwvwbvibu")
    public suspend fun complianceResourceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.complianceResourceTypes = mapped
    }

    /**
     * @param value The tag key that is applied to only those AWS resources that you want you want to trigger an evaluation for the rule.
     */
    @JvmName("eiueeqrfkffijnon")
    public suspend fun tagKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagKey = mapped
    }

    /**
     * @param value The tag value applied to only those AWS resources that you want to trigger an evaluation for the rule.
     */
    @JvmName("ayqwvixlsnpukuts")
    public suspend fun tagValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagValue = mapped
    }

    internal fun build(): RuleScopeArgs = RuleScopeArgs(
        complianceResourceId = complianceResourceId,
        complianceResourceTypes = complianceResourceTypes,
        tagKey = tagKey,
        tagValue = tagValue,
    )
}
