@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.inputs

import com.pulumi.aws.cfg.inputs.RuleSourceSourceDetailArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eventSource The source of the event, such as an AWS service, that triggers AWS Config to evaluate your AWSresources. This defaults to `aws.config` and is the only valid value.
 * @property maximumExecutionFrequency The frequency that you want AWS Config to run evaluations for a rule that istriggered periodically. If specified, requires `message_type` to be `ScheduledNotification`.
 * @property messageType The type of notification that triggers AWS Config to run an evaluation for a rule. You canspecify the following notification types:
 * * `ConfigurationItemChangeNotification` - Triggers an evaluation when AWS Config delivers a configuration item as a result of a resource change.
 * * `OversizedConfigurationItemChangeNotification` - Triggers an evaluation when AWS Config delivers an oversized configuration item. AWS Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.
 * * `ScheduledNotification` - Triggers a periodic evaluation at the frequency specified for `maximum_execution_frequency`.
 * * `ConfigurationSnapshotDeliveryCompleted` - Triggers a periodic evaluation when AWS Config delivers a configuration snapshot.
 */
public data class RuleSourceSourceDetailArgs(
    public val eventSource: Output<String>? = null,
    public val maximumExecutionFrequency: Output<String>? = null,
    public val messageType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.inputs.RuleSourceSourceDetailArgs> {
    override fun toJava(): com.pulumi.aws.cfg.inputs.RuleSourceSourceDetailArgs =
        com.pulumi.aws.cfg.inputs.RuleSourceSourceDetailArgs.builder()
            .eventSource(eventSource?.applyValue({ args0 -> args0 }))
            .maximumExecutionFrequency(maximumExecutionFrequency?.applyValue({ args0 -> args0 }))
            .messageType(messageType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleSourceSourceDetailArgs].
 */
@PulumiTagMarker
public class RuleSourceSourceDetailArgsBuilder internal constructor() {
    private var eventSource: Output<String>? = null

    private var maximumExecutionFrequency: Output<String>? = null

    private var messageType: Output<String>? = null

    /**
     * @param value The source of the event, such as an AWS service, that triggers AWS Config to evaluate your AWSresources. This defaults to `aws.config` and is the only valid value.
     */
    @JvmName("iebkqkbmdocbmcoq")
    public suspend fun eventSource(`value`: Output<String>) {
        this.eventSource = value
    }

    /**
     * @param value The frequency that you want AWS Config to run evaluations for a rule that istriggered periodically. If specified, requires `message_type` to be `ScheduledNotification`.
     */
    @JvmName("ncnvcwkxtjkbhgph")
    public suspend fun maximumExecutionFrequency(`value`: Output<String>) {
        this.maximumExecutionFrequency = value
    }

    /**
     * @param value The type of notification that triggers AWS Config to run an evaluation for a rule. You canspecify the following notification types:
     * * `ConfigurationItemChangeNotification` - Triggers an evaluation when AWS Config delivers a configuration item as a result of a resource change.
     * * `OversizedConfigurationItemChangeNotification` - Triggers an evaluation when AWS Config delivers an oversized configuration item. AWS Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.
     * * `ScheduledNotification` - Triggers a periodic evaluation at the frequency specified for `maximum_execution_frequency`.
     * * `ConfigurationSnapshotDeliveryCompleted` - Triggers a periodic evaluation when AWS Config delivers a configuration snapshot.
     */
    @JvmName("jexwnjexwkvmxmhl")
    public suspend fun messageType(`value`: Output<String>) {
        this.messageType = value
    }

    /**
     * @param value The source of the event, such as an AWS service, that triggers AWS Config to evaluate your AWSresources. This defaults to `aws.config` and is the only valid value.
     */
    @JvmName("sdtpqxsevwqyafut")
    public suspend fun eventSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSource = mapped
    }

    /**
     * @param value The frequency that you want AWS Config to run evaluations for a rule that istriggered periodically. If specified, requires `message_type` to be `ScheduledNotification`.
     */
    @JvmName("efugvgivjsjlnojv")
    public suspend fun maximumExecutionFrequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumExecutionFrequency = mapped
    }

    /**
     * @param value The type of notification that triggers AWS Config to run an evaluation for a rule. You canspecify the following notification types:
     * * `ConfigurationItemChangeNotification` - Triggers an evaluation when AWS Config delivers a configuration item as a result of a resource change.
     * * `OversizedConfigurationItemChangeNotification` - Triggers an evaluation when AWS Config delivers an oversized configuration item. AWS Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.
     * * `ScheduledNotification` - Triggers a periodic evaluation at the frequency specified for `maximum_execution_frequency`.
     * * `ConfigurationSnapshotDeliveryCompleted` - Triggers a periodic evaluation when AWS Config delivers a configuration snapshot.
     */
    @JvmName("fyoymoypufnbyfvu")
    public suspend fun messageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageType = mapped
    }

    internal fun build(): RuleSourceSourceDetailArgs = RuleSourceSourceDetailArgs(
        eventSource = eventSource,
        maximumExecutionFrequency = maximumExecutionFrequency,
        messageType = messageType,
    )
}
