@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allRegions If true, aggregate existing AWS Config regions and future regions.
 * @property regions List of source regions being aggregated.
 * @property roleArn ARN of the IAM role used to retrieve AWS Organization details associated with the aggregator account.
 * Either `regions` or `all_regions` (as true) must be specified.
 */
public data class ConfigurationAggregatorOrganizationAggregationSource(
    public val allRegions: Boolean? = null,
    public val regions: List<String>? = null,
    public val roleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cfg.outputs.ConfigurationAggregatorOrganizationAggregationSource): ConfigurationAggregatorOrganizationAggregationSource =
            ConfigurationAggregatorOrganizationAggregationSource(
                allRegions = javaType.allRegions().map({ args0 -> args0 }).orElse(null),
                regions = javaType.regions().map({ args0 -> args0 }),
                roleArn = javaType.roleArn(),
            )
    }
}
