@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property parameterName The input key.
 * @property parameterValue The input value.
 */
public data class ConformancePackInputParameter(
    public val parameterName: String,
    public val parameterValue: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cfg.outputs.ConformancePackInputParameter): ConformancePackInputParameter = ConformancePackInputParameter(
            parameterName = javaType.parameterName(),
            parameterValue = javaType.parameterValue(),
        )
    }
}
