@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deliveryFrequency The frequency with which AWS Config recurringly delivers configuration snapshotsE.g., `One_Hour` or `Three_Hours`. Valid values are listed [here](https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigSnapshotDeliveryProperties.html#API_ConfigSnapshotDeliveryProperties_Contents).
 */
public data class DeliveryChannelSnapshotDeliveryProperties(
    public val deliveryFrequency: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cfg.outputs.DeliveryChannelSnapshotDeliveryProperties): DeliveryChannelSnapshotDeliveryProperties = DeliveryChannelSnapshotDeliveryProperties(
            deliveryFrequency = javaType.deliveryFrequency().map({ args0 -> args0 }).orElse(null),
        )
    }
}
