@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allSupported Specifies whether AWS Config records configuration changes for every supported type of regional resource (which includes any new type that will become supported in the future). Conflicts with `resource_types`. Defaults to `true`.
 * @property exclusionByResourceTypes An object that specifies how AWS Config excludes resource types from being recorded by the configuration recorder.To use this option, you must set the useOnly field of RecordingStrategy to `EXCLUSION_BY_RESOURCE_TYPES` Requires `all_supported = false`. Conflicts with `resource_types`.
 * @property includeGlobalResourceTypes Specifies whether AWS Config includes all supported types of _global resources_ with the resources that it records. Requires `all_supported = true`. Conflicts with `resource_types`.
 * @property recordingStrategies Recording Strategy. Detailed below.
 * @property resourceTypes A list that specifies the types of AWS resources for which AWS Config records configuration changes (for example, `AWS::EC2::Instance` or `AWS::CloudTrail::Trail`). See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types. In order to use this attribute, `all_supported` must be set to false.
 */
public data class RecorderRecordingGroup(
    public val allSupported: Boolean? = null,
    public val exclusionByResourceTypes: List<RecorderRecordingGroupExclusionByResourceType>? = null,
    public val includeGlobalResourceTypes: Boolean? = null,
    public val recordingStrategies: List<RecorderRecordingGroupRecordingStrategy>? = null,
    public val resourceTypes: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cfg.outputs.RecorderRecordingGroup): RecorderRecordingGroup = RecorderRecordingGroup(
            allSupported = javaType.allSupported().map({ args0 -> args0 }).orElse(null),
            exclusionByResourceTypes = javaType.exclusionByResourceTypes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cfg.kotlin.outputs.RecorderRecordingGroupExclusionByResourceType.Companion.toKotlin(args0)
                })
            }),
            includeGlobalResourceTypes = javaType.includeGlobalResourceTypes().map({ args0 ->
                args0
            }).orElse(null),
            recordingStrategies = javaType.recordingStrategies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cfg.kotlin.outputs.RecorderRecordingGroupRecordingStrategy.Companion.toKotlin(args0)
                })
            }),
            resourceTypes = javaType.resourceTypes().map({ args0 -> args0 }),
        )
    }
}
