@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property resourceTypes A list that specifies the types of AWS resources for which AWS Config excludes records configuration changes. See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types.
 */
public data class RecorderRecordingGroupExclusionByResourceType(
    public val resourceTypes: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cfg.outputs.RecorderRecordingGroupExclusionByResourceType): RecorderRecordingGroupExclusionByResourceType =
            RecorderRecordingGroupExclusionByResourceType(
                resourceTypes = javaType.resourceTypes().map({ args0 -> args0 }),
            )
    }
}
