@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property recordingFrequency Default reecording frequency. `CONTINUOUS` or `DAILY`.
 * @property recordingModeOverride Recording mode overrides. Detailed below.
 */
public data class RecorderRecordingMode(
    public val recordingFrequency: String? = null,
    public val recordingModeOverride: RecorderRecordingModeRecordingModeOverride? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cfg.outputs.RecorderRecordingMode): RecorderRecordingMode = RecorderRecordingMode(
            recordingFrequency = javaType.recordingFrequency().map({ args0 -> args0 }).orElse(null),
            recordingModeOverride = javaType.recordingModeOverride().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cfg.kotlin.outputs.RecorderRecordingModeRecordingModeOverride.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
