@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property description A description you provide of the override.
 * @property recordingFrequency The recording frequency for the resources in the override block. `CONTINUOUS` or `DAILY`.
 * @property resourceTypes A list that specifies the types of AWS resources for which the override applies to.  See [restrictions in the AWS Docs](https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingModeOverride.html)
 */
public data class RecorderRecordingModeRecordingModeOverride(
    public val description: String? = null,
    public val recordingFrequency: String,
    public val resourceTypes: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cfg.outputs.RecorderRecordingModeRecordingModeOverride): RecorderRecordingModeRecordingModeOverride = RecorderRecordingModeRecordingModeOverride(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            recordingFrequency = javaType.recordingFrequency(),
            resourceTypes = javaType.resourceTypes().map({ args0 -> args0 }),
        )
    }
}
