@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property concurrentExecutionRatePercentage Maximum percentage of remediation actions allowed to run in parallel on the non-compliant resources for that specific rule. The default value is 10%.
 * @property errorPercentage Percentage of errors that are allowed before SSM stops running automations on non-compliant resources for that specific rule. The default is 50%.
 */
public data class RemediationConfigurationExecutionControlsSsmControls(
    public val concurrentExecutionRatePercentage: Int? = null,
    public val errorPercentage: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cfg.outputs.RemediationConfigurationExecutionControlsSsmControls): RemediationConfigurationExecutionControlsSsmControls =
            RemediationConfigurationExecutionControlsSsmControls(
                concurrentExecutionRatePercentage = javaType.concurrentExecutionRatePercentage().map({ args0 ->
                    args0
                }).orElse(null),
                errorPercentage = javaType.errorPercentage().map({ args0 -> args0 }).orElse(null),
            )
    }
}
