@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property complianceResourceId The IDs of the only AWS resource that you want to trigger an evaluation for the rule. If you specify a resource ID, you must specify one resource type for `compliance_resource_types`.
 * @property complianceResourceTypes A list of resource types of only those AWS resources that you want to trigger an evaluation for the ruleE.g., `AWS::EC2::Instance`. You can only specify one type if you also specify a resource ID for `compliance_resource_id`. See [relevant part of AWS Docs](http://docs.aws.amazon.com/config/latest/APIReference/API_ResourceIdentifier.html#config-Type-ResourceIdentifier-resourceType) for available types.
 * @property tagKey The tag key that is applied to only those AWS resources that you want you want to trigger an evaluation for the rule.
 * @property tagValue The tag value applied to only those AWS resources that you want to trigger an evaluation for the rule.
 */
public data class RuleScope(
    public val complianceResourceId: String? = null,
    public val complianceResourceTypes: List<String>? = null,
    public val tagKey: String? = null,
    public val tagValue: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cfg.outputs.RuleScope): RuleScope = RuleScope(
            complianceResourceId = javaType.complianceResourceId().map({ args0 -> args0 }).orElse(null),
            complianceResourceTypes = javaType.complianceResourceTypes().map({ args0 -> args0 }),
            tagKey = javaType.tagKey().map({ args0 -> args0 }).orElse(null),
            tagValue = javaType.tagValue().map({ args0 -> args0 }).orElse(null),
        )
    }
}
