@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property customPolicyDetails Provides the runtime system, policy definition, and whether debug logging is enabled. Required when owner is set to `CUSTOM_POLICY`. See Custom Policy Details Below.
 * @property owner Indicates whether AWS or the customer owns and manages the AWS Config rule. Valid values are `AWS`, `CUSTOM_LAMBDA` or `CUSTOM_POLICY`. For more information about managed rules, see the [AWS Config Managed Rules documentation](https://docs&#46;aws&#46;amazon&#46;com/config/latest/developerguide/evaluate-config_use-managed-rules&#46;html)&#46; For more information about custom rules, see the [AWS Config Custom Rules documentation](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html). Custom Lambda Functions require permissions to allow the AWS Config service to invoke them, e.g., via the `aws.lambda.Permission` resource.
 * @property sourceDetails Provides the source and type of the event that causes AWS Config to evaluate your AWS resources. Only valid if `owner` is `CUSTOM_LAMBDA` or `CUSTOM_POLICY`. See Source Detail Below.
 * @property sourceIdentifier For AWS Config managed rules, a predefined identifier, e.g `IAM_PASSWORD_POLICY`. For custom Lambda rules, the identifier is the ARN of the Lambda Function, such as `arn:aws:lambda:us-east-1:123456789012:function:custom_rule_name` or the `arn` attribute of the `aws.lambda.Function` resource.
 */
public data class RuleSource(
    public val customPolicyDetails: RuleSourceCustomPolicyDetails? = null,
    public val owner: String,
    public val sourceDetails: List<RuleSourceSourceDetail>? = null,
    public val sourceIdentifier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cfg.outputs.RuleSource): RuleSource = RuleSource(
            customPolicyDetails = javaType.customPolicyDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cfg.kotlin.outputs.RuleSourceCustomPolicyDetails.Companion.toKotlin(args0)
                })
            }).orElse(null),
            owner = javaType.owner(),
            sourceDetails = javaType.sourceDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cfg.kotlin.outputs.RuleSourceSourceDetail.Companion.toKotlin(args0)
                })
            }),
            sourceIdentifier = javaType.sourceIdentifier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
