@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property eventSource The source of the event, such as an AWS service, that triggers AWS Config to evaluate your AWSresources. This defaults to `aws.config` and is the only valid value.
 * @property maximumExecutionFrequency The frequency that you want AWS Config to run evaluations for a rule that istriggered periodically. If specified, requires `message_type` to be `ScheduledNotification`.
 * @property messageType The type of notification that triggers AWS Config to run an evaluation for a rule. You canspecify the following notification types:
 * * `ConfigurationItemChangeNotification` - Triggers an evaluation when AWS Config delivers a configuration item as a result of a resource change.
 * * `OversizedConfigurationItemChangeNotification` - Triggers an evaluation when AWS Config delivers an oversized configuration item. AWS Config may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.
 * * `ScheduledNotification` - Triggers a periodic evaluation at the frequency specified for `maximum_execution_frequency`.
 * * `ConfigurationSnapshotDeliveryCompleted` - Triggers a periodic evaluation when AWS Config delivers a configuration snapshot.
 */
public data class RuleSourceSourceDetail(
    public val eventSource: String? = null,
    public val maximumExecutionFrequency: String? = null,
    public val messageType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cfg.outputs.RuleSourceSourceDetail): RuleSourceSourceDetail = RuleSourceSourceDetail(
            eventSource = javaType.eventSource().map({ args0 -> args0 }).orElse(null),
            maximumExecutionFrequency = javaType.maximumExecutionFrequency().map({ args0 ->
                args0
            }).orElse(null),
            messageType = javaType.messageType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
