@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chatbot.kotlin

import com.pulumi.aws.chatbot.ChatbotFunctions.getSlackWorkspacePlain
import com.pulumi.aws.chatbot.kotlin.inputs.GetSlackWorkspacePlainArgs
import com.pulumi.aws.chatbot.kotlin.inputs.GetSlackWorkspacePlainArgsBuilder
import com.pulumi.aws.chatbot.kotlin.outputs.GetSlackWorkspaceResult
import com.pulumi.aws.chatbot.kotlin.outputs.GetSlackWorkspaceResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object ChatbotFunctions {
    /**
     * Data source for managing an AWS Chatbot Slack Workspace.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.chatbot.getSlackWorkspace({
     *     slackTeamName: "abc",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.chatbot.get_slack_workspace(slack_team_name="abc")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Chatbot.GetSlackWorkspace.Invoke(new()
     *     {
     *         SlackTeamName = "abc",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/chatbot"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := chatbot.GetSlackWorkspace(ctx, &chatbot.GetSlackWorkspaceArgs{
     * 			SlackTeamName: "abc",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.chatbot.ChatbotFunctions;
     * import com.pulumi.aws.chatbot.inputs.GetSlackWorkspaceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ChatbotFunctions.getSlackWorkspace(GetSlackWorkspaceArgs.builder()
     *             .slackTeamName("abc")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:chatbot:getSlackWorkspace
     *       Arguments:
     *         slackTeamName: abc
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSlackWorkspace.
     * @return A collection of values returned by getSlackWorkspace.
     */
    public suspend fun getSlackWorkspace(argument: GetSlackWorkspacePlainArgs): GetSlackWorkspaceResult = toKotlin(getSlackWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getSlackWorkspace].
     * @param slackTeamName Slack workspace name configured with AWS Chatbot.
     * @return A collection of values returned by getSlackWorkspace.
     */
    public suspend fun getSlackWorkspace(slackTeamName: String): GetSlackWorkspaceResult {
        val argument = GetSlackWorkspacePlainArgs(
            slackTeamName = slackTeamName,
        )
        return toKotlin(getSlackWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getSlackWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;chatbot&#46;kotlin&#46;inputs&#46;GetSlackWorkspacePlainArgs].
     * @return A collection of values returned by getSlackWorkspace.
     */
    public suspend fun getSlackWorkspace(argument: suspend GetSlackWorkspacePlainArgsBuilder.() -> Unit): GetSlackWorkspaceResult {
        val builder = GetSlackWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getSlackWorkspacePlain(builtArgument.toJava()).await())
    }
}
