@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chatbot.kotlin

import com.pulumi.aws.chatbot.kotlin.outputs.SlackChannelConfigurationTimeouts
import com.pulumi.aws.chatbot.kotlin.outputs.SlackChannelConfigurationTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [SlackChannelConfiguration].
 */
@PulumiTagMarker
public class SlackChannelConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SlackChannelConfigurationArgs = SlackChannelConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SlackChannelConfigurationArgsBuilder.() -> Unit) {
        val builder = SlackChannelConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SlackChannelConfiguration {
        val builtJavaResource =
            com.pulumi.aws.chatbot.SlackChannelConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SlackChannelConfiguration(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Chatbot Slack Channel Configuration.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.chatbot.SlackChannelConfiguration("test", {
 *     configurationName: "min-slaka-kanal",
 *     iamRoleArn: testAwsIamRole.arn,
 *     slackChannelId: "C07EZ1ABC23",
 *     slackTeamId: "T07EA123LEP",
 *     tags: {
 *         Name: "min-slaka-kanal",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.chatbot.SlackChannelConfiguration("test",
 *     configuration_name="min-slaka-kanal",
 *     iam_role_arn=test_aws_iam_role["arn"],
 *     slack_channel_id="C07EZ1ABC23",
 *     slack_team_id="T07EA123LEP",
 *     tags={
 *         "Name": "min-slaka-kanal",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Chatbot.SlackChannelConfiguration("test", new()
 *     {
 *         ConfigurationName = "min-slaka-kanal",
 *         IamRoleArn = testAwsIamRole.Arn,
 *         SlackChannelId = "C07EZ1ABC23",
 *         SlackTeamId = "T07EA123LEP",
 *         Tags =
 *         {
 *             { "Name", "min-slaka-kanal" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/chatbot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := chatbot.NewSlackChannelConfiguration(ctx, "test", &chatbot.SlackChannelConfigurationArgs{
 * 			ConfigurationName: pulumi.String("min-slaka-kanal"),
 * 			IamRoleArn:        pulumi.Any(testAwsIamRole.Arn),
 * 			SlackChannelId:    pulumi.String("C07EZ1ABC23"),
 * 			SlackTeamId:       pulumi.String("T07EA123LEP"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("min-slaka-kanal"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chatbot.SlackChannelConfiguration;
 * import com.pulumi.aws.chatbot.SlackChannelConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new SlackChannelConfiguration("test", SlackChannelConfigurationArgs.builder()
 *             .configurationName("min-slaka-kanal")
 *             .iamRoleArn(testAwsIamRole.arn())
 *             .slackChannelId("C07EZ1ABC23")
 *             .slackTeamId("T07EA123LEP")
 *             .tags(Map.of("Name", "min-slaka-kanal"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:chatbot:SlackChannelConfiguration
 *     properties:
 *       configurationName: min-slaka-kanal
 *       iamRoleArn: ${testAwsIamRole.arn}
 *       slackChannelId: C07EZ1ABC23
 *       slackTeamId: T07EA123LEP
 *       tags:
 *         Name: min-slaka-kanal
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Chatbot Slack Channel Configuration using the `chat_configuration_arn`. For example:
 * ```sh
 * $ pulumi import aws:chatbot/slackChannelConfiguration:SlackChannelConfiguration example arn:aws:chatbot::012345678901:chat-configuration/slack-channel/min-slaka-kanal
 * ```
 */
public class SlackChannelConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.chatbot.SlackChannelConfiguration,
) : KotlinCustomResource(javaResource, SlackChannelConfigurationMapper) {
    /**
     * ARN of the Slack channel configuration.
     */
    public val chatConfigurationArn: Output<String>
        get() = javaResource.chatConfigurationArn().applyValue({ args0 -> args0 })

    /**
     * Name of the Slack channel configuration.
     */
    public val configurationName: Output<String>
        get() = javaResource.configurationName().applyValue({ args0 -> args0 })

    /**
     * List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
     */
    public val guardrailPolicyArns: Output<List<String>>
        get() = javaResource.guardrailPolicyArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * User-defined role that AWS Chatbot assumes. This is not the service-linked role.
     */
    public val iamRoleArn: Output<String>
        get() = javaResource.iamRoleArn().applyValue({ args0 -> args0 })

    /**
     * Logging levels include `ERROR`, `INFO`, or `NONE`.
     */
    public val loggingLevel: Output<String>
        get() = javaResource.loggingLevel().applyValue({ args0 -> args0 })

    /**
     * ID of the Slack channel. For example, `C07EZ1ABC23`.
     */
    public val slackChannelId: Output<String>
        get() = javaResource.slackChannelId().applyValue({ args0 -> args0 })

    /**
     * Name of the Slack channel.
     */
    public val slackChannelName: Output<String>
        get() = javaResource.slackChannelName().applyValue({ args0 -> args0 })

    /**
     * ID of the Slack workspace authorized with AWS Chatbot. For example, `T07EA123LEP`.
     * The following arguments are optional:
     */
    public val slackTeamId: Output<String>
        get() = javaResource.slackTeamId().applyValue({ args0 -> args0 })

    /**
     * Name of the Slack team.
     */
    public val slackTeamName: Output<String>
        get() = javaResource.slackTeamName().applyValue({ args0 -> args0 })

    /**
     * ARNs of the SNS topics that deliver notifications to AWS Chatbot.
     */
    public val snsTopicArns: Output<List<String>>
        get() = javaResource.snsTopicArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Map of tags assigned to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<SlackChannelConfigurationTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Enables use of a user role requirement in your chat configuration.
     */
    public val userAuthorizationRequired: Output<Boolean>
        get() = javaResource.userAuthorizationRequired().applyValue({ args0 -> args0 })
}

public object SlackChannelConfigurationMapper : ResourceMapper<SlackChannelConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.chatbot.SlackChannelConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): SlackChannelConfiguration =
        SlackChannelConfiguration(javaResource as com.pulumi.aws.chatbot.SlackChannelConfiguration)
}

/**
 * @see [SlackChannelConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SlackChannelConfiguration].
 */
public suspend fun slackChannelConfiguration(
    name: String,
    block: suspend SlackChannelConfigurationResourceBuilder.() -> Unit,
): SlackChannelConfiguration {
    val builder = SlackChannelConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SlackChannelConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun slackChannelConfiguration(name: String): SlackChannelConfiguration {
    val builder = SlackChannelConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
