@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chatbot.kotlin

import com.pulumi.aws.chatbot.SlackChannelConfigurationArgs.builder
import com.pulumi.aws.chatbot.kotlin.inputs.SlackChannelConfigurationTimeoutsArgs
import com.pulumi.aws.chatbot.kotlin.inputs.SlackChannelConfigurationTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Chatbot Slack Channel Configuration.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.chatbot.SlackChannelConfiguration("test", {
 *     configurationName: "min-slaka-kanal",
 *     iamRoleArn: testAwsIamRole.arn,
 *     slackChannelId: "C07EZ1ABC23",
 *     slackTeamId: "T07EA123LEP",
 *     tags: {
 *         Name: "min-slaka-kanal",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.chatbot.SlackChannelConfiguration("test",
 *     configuration_name="min-slaka-kanal",
 *     iam_role_arn=test_aws_iam_role["arn"],
 *     slack_channel_id="C07EZ1ABC23",
 *     slack_team_id="T07EA123LEP",
 *     tags={
 *         "Name": "min-slaka-kanal",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Chatbot.SlackChannelConfiguration("test", new()
 *     {
 *         ConfigurationName = "min-slaka-kanal",
 *         IamRoleArn = testAwsIamRole.Arn,
 *         SlackChannelId = "C07EZ1ABC23",
 *         SlackTeamId = "T07EA123LEP",
 *         Tags =
 *         {
 *             { "Name", "min-slaka-kanal" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/chatbot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := chatbot.NewSlackChannelConfiguration(ctx, "test", &chatbot.SlackChannelConfigurationArgs{
 * 			ConfigurationName: pulumi.String("min-slaka-kanal"),
 * 			IamRoleArn:        pulumi.Any(testAwsIamRole.Arn),
 * 			SlackChannelId:    pulumi.String("C07EZ1ABC23"),
 * 			SlackTeamId:       pulumi.String("T07EA123LEP"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("min-slaka-kanal"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chatbot.SlackChannelConfiguration;
 * import com.pulumi.aws.chatbot.SlackChannelConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new SlackChannelConfiguration("test", SlackChannelConfigurationArgs.builder()
 *             .configurationName("min-slaka-kanal")
 *             .iamRoleArn(testAwsIamRole.arn())
 *             .slackChannelId("C07EZ1ABC23")
 *             .slackTeamId("T07EA123LEP")
 *             .tags(Map.of("Name", "min-slaka-kanal"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:chatbot:SlackChannelConfiguration
 *     properties:
 *       configurationName: min-slaka-kanal
 *       iamRoleArn: ${testAwsIamRole.arn}
 *       slackChannelId: C07EZ1ABC23
 *       slackTeamId: T07EA123LEP
 *       tags:
 *         Name: min-slaka-kanal
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Chatbot Slack Channel Configuration using the `chat_configuration_arn`. For example:
 * ```sh
 * $ pulumi import aws:chatbot/slackChannelConfiguration:SlackChannelConfiguration example arn:aws:chatbot::012345678901:chat-configuration/slack-channel/min-slaka-kanal
 * ```
 * @property configurationName Name of the Slack channel configuration.
 * @property guardrailPolicyArns List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
 * @property iamRoleArn User-defined role that AWS Chatbot assumes. This is not the service-linked role.
 * @property loggingLevel Logging levels include `ERROR`, `INFO`, or `NONE`.
 * @property slackChannelId ID of the Slack channel. For example, `C07EZ1ABC23`.
 * @property slackTeamId ID of the Slack workspace authorized with AWS Chatbot. For example, `T07EA123LEP`.
 * The following arguments are optional:
 * @property snsTopicArns ARNs of the SNS topics that deliver notifications to AWS Chatbot.
 * @property tags Map of tags assigned to the resource.
 * @property timeouts
 * @property userAuthorizationRequired Enables use of a user role requirement in your chat configuration.
 */
public data class SlackChannelConfigurationArgs(
    public val configurationName: Output<String>? = null,
    public val guardrailPolicyArns: Output<List<String>>? = null,
    public val iamRoleArn: Output<String>? = null,
    public val loggingLevel: Output<String>? = null,
    public val slackChannelId: Output<String>? = null,
    public val slackTeamId: Output<String>? = null,
    public val snsTopicArns: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<SlackChannelConfigurationTimeoutsArgs>? = null,
    public val userAuthorizationRequired: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.chatbot.SlackChannelConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.chatbot.SlackChannelConfigurationArgs =
        com.pulumi.aws.chatbot.SlackChannelConfigurationArgs.builder()
            .configurationName(configurationName?.applyValue({ args0 -> args0 }))
            .guardrailPolicyArns(guardrailPolicyArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .iamRoleArn(iamRoleArn?.applyValue({ args0 -> args0 }))
            .loggingLevel(loggingLevel?.applyValue({ args0 -> args0 }))
            .slackChannelId(slackChannelId?.applyValue({ args0 -> args0 }))
            .slackTeamId(slackTeamId?.applyValue({ args0 -> args0 }))
            .snsTopicArns(snsTopicArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userAuthorizationRequired(userAuthorizationRequired?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SlackChannelConfigurationArgs].
 */
@PulumiTagMarker
public class SlackChannelConfigurationArgsBuilder internal constructor() {
    private var configurationName: Output<String>? = null

    private var guardrailPolicyArns: Output<List<String>>? = null

    private var iamRoleArn: Output<String>? = null

    private var loggingLevel: Output<String>? = null

    private var slackChannelId: Output<String>? = null

    private var slackTeamId: Output<String>? = null

    private var snsTopicArns: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<SlackChannelConfigurationTimeoutsArgs>? = null

    private var userAuthorizationRequired: Output<Boolean>? = null

    /**
     * @param value Name of the Slack channel configuration.
     */
    @JvmName("wtahrxkqyubgvwud")
    public suspend fun configurationName(`value`: Output<String>) {
        this.configurationName = value
    }

    /**
     * @param value List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
     */
    @JvmName("bijengrukxjdaoim")
    public suspend fun guardrailPolicyArns(`value`: Output<List<String>>) {
        this.guardrailPolicyArns = value
    }

    @JvmName("jnmpyydsntuhvcjl")
    public suspend fun guardrailPolicyArns(vararg values: Output<String>) {
        this.guardrailPolicyArns = Output.all(values.asList())
    }

    /**
     * @param values List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
     */
    @JvmName("bpsscoialnbeetes")
    public suspend fun guardrailPolicyArns(values: List<Output<String>>) {
        this.guardrailPolicyArns = Output.all(values)
    }

    /**
     * @param value User-defined role that AWS Chatbot assumes. This is not the service-linked role.
     */
    @JvmName("vbhhvhqtreqyxcph")
    public suspend fun iamRoleArn(`value`: Output<String>) {
        this.iamRoleArn = value
    }

    /**
     * @param value Logging levels include `ERROR`, `INFO`, or `NONE`.
     */
    @JvmName("oitdtkicrbphodql")
    public suspend fun loggingLevel(`value`: Output<String>) {
        this.loggingLevel = value
    }

    /**
     * @param value ID of the Slack channel. For example, `C07EZ1ABC23`.
     */
    @JvmName("hkstsqhdmrxmaklb")
    public suspend fun slackChannelId(`value`: Output<String>) {
        this.slackChannelId = value
    }

    /**
     * @param value ID of the Slack workspace authorized with AWS Chatbot. For example, `T07EA123LEP`.
     * The following arguments are optional:
     */
    @JvmName("saintamtgstpmteb")
    public suspend fun slackTeamId(`value`: Output<String>) {
        this.slackTeamId = value
    }

    /**
     * @param value ARNs of the SNS topics that deliver notifications to AWS Chatbot.
     */
    @JvmName("kntqahtlwfyfajts")
    public suspend fun snsTopicArns(`value`: Output<List<String>>) {
        this.snsTopicArns = value
    }

    @JvmName("sjnhhicxrwurvewr")
    public suspend fun snsTopicArns(vararg values: Output<String>) {
        this.snsTopicArns = Output.all(values.asList())
    }

    /**
     * @param values ARNs of the SNS topics that deliver notifications to AWS Chatbot.
     */
    @JvmName("sthgwymasaummdnp")
    public suspend fun snsTopicArns(values: List<Output<String>>) {
        this.snsTopicArns = Output.all(values)
    }

    /**
     * @param value Map of tags assigned to the resource.
     */
    @JvmName("gfruxjmgpugwaolq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("qfathpnvptskmxot")
    public suspend fun timeouts(`value`: Output<SlackChannelConfigurationTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Enables use of a user role requirement in your chat configuration.
     */
    @JvmName("bjtyshiftpkwveau")
    public suspend fun userAuthorizationRequired(`value`: Output<Boolean>) {
        this.userAuthorizationRequired = value
    }

    /**
     * @param value Name of the Slack channel configuration.
     */
    @JvmName("medlagypmohtumbi")
    public suspend fun configurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationName = mapped
    }

    /**
     * @param value List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
     */
    @JvmName("jepvbdroojxkytcm")
    public suspend fun guardrailPolicyArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guardrailPolicyArns = mapped
    }

    /**
     * @param values List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
     */
    @JvmName("queqscabacydmlia")
    public suspend fun guardrailPolicyArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.guardrailPolicyArns = mapped
    }

    /**
     * @param value User-defined role that AWS Chatbot assumes. This is not the service-linked role.
     */
    @JvmName("qnewmpxouruysvue")
    public suspend fun iamRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRoleArn = mapped
    }

    /**
     * @param value Logging levels include `ERROR`, `INFO`, or `NONE`.
     */
    @JvmName("ahspglgqlgrptbxu")
    public suspend fun loggingLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingLevel = mapped
    }

    /**
     * @param value ID of the Slack channel. For example, `C07EZ1ABC23`.
     */
    @JvmName("vadyrsntjeyagwiy")
    public suspend fun slackChannelId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slackChannelId = mapped
    }

    /**
     * @param value ID of the Slack workspace authorized with AWS Chatbot. For example, `T07EA123LEP`.
     * The following arguments are optional:
     */
    @JvmName("dgbsseenvhwulnfe")
    public suspend fun slackTeamId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slackTeamId = mapped
    }

    /**
     * @param value ARNs of the SNS topics that deliver notifications to AWS Chatbot.
     */
    @JvmName("dhyfwqaylfgrsmhc")
    public suspend fun snsTopicArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snsTopicArns = mapped
    }

    /**
     * @param values ARNs of the SNS topics that deliver notifications to AWS Chatbot.
     */
    @JvmName("rlnaihnxluqjfvcg")
    public suspend fun snsTopicArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snsTopicArns = mapped
    }

    /**
     * @param value Map of tags assigned to the resource.
     */
    @JvmName("vrmqgpaucausxcfs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the resource.
     */
    @JvmName("fxaekuhgbqrnpvpo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("widoyootbynbpaar")
    public suspend fun timeouts(`value`: SlackChannelConfigurationTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("maifvgfaprwxyobw")
    public suspend fun timeouts(argument: suspend SlackChannelConfigurationTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = SlackChannelConfigurationTimeoutsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    /**
     * @param value Enables use of a user role requirement in your chat configuration.
     */
    @JvmName("xrrkiblvgajsdgux")
    public suspend fun userAuthorizationRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAuthorizationRequired = mapped
    }

    internal fun build(): SlackChannelConfigurationArgs = SlackChannelConfigurationArgs(
        configurationName = configurationName,
        guardrailPolicyArns = guardrailPolicyArns,
        iamRoleArn = iamRoleArn,
        loggingLevel = loggingLevel,
        slackChannelId = slackChannelId,
        slackTeamId = slackTeamId,
        snsTopicArns = snsTopicArns,
        tags = tags,
        timeouts = timeouts,
        userAuthorizationRequired = userAuthorizationRequired,
    )
}
