@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chatbot.kotlin

import com.pulumi.aws.chatbot.kotlin.outputs.TeamsChannelConfigurationTimeouts
import com.pulumi.aws.chatbot.kotlin.outputs.TeamsChannelConfigurationTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [TeamsChannelConfiguration].
 */
@PulumiTagMarker
public class TeamsChannelConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TeamsChannelConfigurationArgs = TeamsChannelConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TeamsChannelConfigurationArgsBuilder.() -> Unit) {
        val builder = TeamsChannelConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TeamsChannelConfiguration {
        val builtJavaResource =
            com.pulumi.aws.chatbot.TeamsChannelConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TeamsChannelConfiguration(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Chatbot Microsoft Teams Channel Configuration.
 * > **NOTE:** We provide this resource on a best-effort basis. If you are able to test it and find it useful, we welcome your input at GitHub.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.chatbot.TeamsChannelConfiguration("test", {
 *     channelId: "C07EZ1ABC23",
 *     configurationName: "mitt-lags-kanal",
 *     iamRoleArn: testAwsIamRole.arn,
 *     teamId: "74361522-da01-538d-aa2e-ac7918c6bb92",
 *     tenantId: "1234",
 *     tags: {
 *         Name: "mitt-lags-kanal",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.chatbot.TeamsChannelConfiguration("test",
 *     channel_id="C07EZ1ABC23",
 *     configuration_name="mitt-lags-kanal",
 *     iam_role_arn=test_aws_iam_role["arn"],
 *     team_id="74361522-da01-538d-aa2e-ac7918c6bb92",
 *     tenant_id="1234",
 *     tags={
 *         "Name": "mitt-lags-kanal",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Chatbot.TeamsChannelConfiguration("test", new()
 *     {
 *         ChannelId = "C07EZ1ABC23",
 *         ConfigurationName = "mitt-lags-kanal",
 *         IamRoleArn = testAwsIamRole.Arn,
 *         TeamId = "74361522-da01-538d-aa2e-ac7918c6bb92",
 *         TenantId = "1234",
 *         Tags =
 *         {
 *             { "Name", "mitt-lags-kanal" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/chatbot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := chatbot.NewTeamsChannelConfiguration(ctx, "test", &chatbot.TeamsChannelConfigurationArgs{
 * 			ChannelId:         pulumi.String("C07EZ1ABC23"),
 * 			ConfigurationName: pulumi.String("mitt-lags-kanal"),
 * 			IamRoleArn:        pulumi.Any(testAwsIamRole.Arn),
 * 			TeamId:            pulumi.String("74361522-da01-538d-aa2e-ac7918c6bb92"),
 * 			TenantId:          pulumi.String("1234"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("mitt-lags-kanal"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chatbot.TeamsChannelConfiguration;
 * import com.pulumi.aws.chatbot.TeamsChannelConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new TeamsChannelConfiguration("test", TeamsChannelConfigurationArgs.builder()
 *             .channelId("C07EZ1ABC23")
 *             .configurationName("mitt-lags-kanal")
 *             .iamRoleArn(testAwsIamRole.arn())
 *             .teamId("74361522-da01-538d-aa2e-ac7918c6bb92")
 *             .tenantId("1234")
 *             .tags(Map.of("Name", "mitt-lags-kanal"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:chatbot:TeamsChannelConfiguration
 *     properties:
 *       channelId: C07EZ1ABC23
 *       configurationName: mitt-lags-kanal
 *       iamRoleArn: ${testAwsIamRole.arn}
 *       teamId: 74361522-da01-538d-aa2e-ac7918c6bb92
 *       tenantId: '1234'
 *       tags:
 *         Name: mitt-lags-kanal
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Chatbot Microsoft Teams Channel Configuration using the `team_id`. For example:
 * ```sh
 * $ pulumi import aws:chatbot/teamsChannelConfiguration:TeamsChannelConfiguration example 5f4f15d2-b958-522a-8333-124aa8bf0925
 * ```
 */
public class TeamsChannelConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.chatbot.TeamsChannelConfiguration,
) : KotlinCustomResource(javaResource, TeamsChannelConfigurationMapper) {
    /**
     * ID of the Microsoft Teams channel.
     */
    public val channelId: Output<String>
        get() = javaResource.channelId().applyValue({ args0 -> args0 })

    /**
     * Name of the Microsoft Teams channel.
     */
    public val channelName: Output<String>
        get() = javaResource.channelName().applyValue({ args0 -> args0 })

    /**
     * ARN of the Microsoft Teams channel configuration.
     */
    public val chatConfigurationArn: Output<String>
        get() = javaResource.chatConfigurationArn().applyValue({ args0 -> args0 })

    /**
     * Name of the Microsoft Teams channel configuration.
     */
    public val configurationName: Output<String>
        get() = javaResource.configurationName().applyValue({ args0 -> args0 })

    /**
     * List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
     */
    public val guardrailPolicyArns: Output<List<String>>
        get() = javaResource.guardrailPolicyArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that AWS Chatbot will assume. This is not the service-linked role.
     */
    public val iamRoleArn: Output<String>
        get() = javaResource.iamRoleArn().applyValue({ args0 -> args0 })

    /**
     * Logging levels include `ERROR`, `INFO`, or `NONE`.
     */
    public val loggingLevel: Output<String>
        get() = javaResource.loggingLevel().applyValue({ args0 -> args0 })

    /**
     * ARNs of the SNS topics that deliver notifications to AWS Chatbot.
     */
    public val snsTopicArns: Output<List<String>>
        get() = javaResource.snsTopicArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Map of tags assigned to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID from the console.
     */
    public val teamId: Output<String>
        get() = javaResource.teamId().applyValue({ args0 -> args0 })

    /**
     * Name of the Microsoft Teams team.
     */
    public val teamName: Output<String>
        get() = javaResource.teamName().applyValue({ args0 -> args0 })

    /**
     * ID of the Microsoft Teams tenant.
     * The following arguments are optional:
     */
    public val tenantId: Output<String>
        get() = javaResource.tenantId().applyValue({ args0 -> args0 })

    public val timeouts: Output<TeamsChannelConfigurationTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Enables use of a user role requirement in your chat configuration.
     */
    public val userAuthorizationRequired: Output<Boolean>
        get() = javaResource.userAuthorizationRequired().applyValue({ args0 -> args0 })
}

public object TeamsChannelConfigurationMapper : ResourceMapper<TeamsChannelConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.chatbot.TeamsChannelConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): TeamsChannelConfiguration =
        TeamsChannelConfiguration(javaResource as com.pulumi.aws.chatbot.TeamsChannelConfiguration)
}

/**
 * @see [TeamsChannelConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TeamsChannelConfiguration].
 */
public suspend fun teamsChannelConfiguration(
    name: String,
    block: suspend TeamsChannelConfigurationResourceBuilder.() -> Unit,
): TeamsChannelConfiguration {
    val builder = TeamsChannelConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TeamsChannelConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun teamsChannelConfiguration(name: String): TeamsChannelConfiguration {
    val builder = TeamsChannelConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
