@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chatbot.kotlin

import com.pulumi.aws.chatbot.TeamsChannelConfigurationArgs.builder
import com.pulumi.aws.chatbot.kotlin.inputs.TeamsChannelConfigurationTimeoutsArgs
import com.pulumi.aws.chatbot.kotlin.inputs.TeamsChannelConfigurationTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Chatbot Microsoft Teams Channel Configuration.
 * > **NOTE:** We provide this resource on a best-effort basis. If you are able to test it and find it useful, we welcome your input at GitHub.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.chatbot.TeamsChannelConfiguration("test", {
 *     channelId: "C07EZ1ABC23",
 *     configurationName: "mitt-lags-kanal",
 *     iamRoleArn: testAwsIamRole.arn,
 *     teamId: "74361522-da01-538d-aa2e-ac7918c6bb92",
 *     tenantId: "1234",
 *     tags: {
 *         Name: "mitt-lags-kanal",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.chatbot.TeamsChannelConfiguration("test",
 *     channel_id="C07EZ1ABC23",
 *     configuration_name="mitt-lags-kanal",
 *     iam_role_arn=test_aws_iam_role["arn"],
 *     team_id="74361522-da01-538d-aa2e-ac7918c6bb92",
 *     tenant_id="1234",
 *     tags={
 *         "Name": "mitt-lags-kanal",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Chatbot.TeamsChannelConfiguration("test", new()
 *     {
 *         ChannelId = "C07EZ1ABC23",
 *         ConfigurationName = "mitt-lags-kanal",
 *         IamRoleArn = testAwsIamRole.Arn,
 *         TeamId = "74361522-da01-538d-aa2e-ac7918c6bb92",
 *         TenantId = "1234",
 *         Tags =
 *         {
 *             { "Name", "mitt-lags-kanal" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/chatbot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := chatbot.NewTeamsChannelConfiguration(ctx, "test", &chatbot.TeamsChannelConfigurationArgs{
 * 			ChannelId:         pulumi.String("C07EZ1ABC23"),
 * 			ConfigurationName: pulumi.String("mitt-lags-kanal"),
 * 			IamRoleArn:        pulumi.Any(testAwsIamRole.Arn),
 * 			TeamId:            pulumi.String("74361522-da01-538d-aa2e-ac7918c6bb92"),
 * 			TenantId:          pulumi.String("1234"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("mitt-lags-kanal"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chatbot.TeamsChannelConfiguration;
 * import com.pulumi.aws.chatbot.TeamsChannelConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new TeamsChannelConfiguration("test", TeamsChannelConfigurationArgs.builder()
 *             .channelId("C07EZ1ABC23")
 *             .configurationName("mitt-lags-kanal")
 *             .iamRoleArn(testAwsIamRole.arn())
 *             .teamId("74361522-da01-538d-aa2e-ac7918c6bb92")
 *             .tenantId("1234")
 *             .tags(Map.of("Name", "mitt-lags-kanal"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:chatbot:TeamsChannelConfiguration
 *     properties:
 *       channelId: C07EZ1ABC23
 *       configurationName: mitt-lags-kanal
 *       iamRoleArn: ${testAwsIamRole.arn}
 *       teamId: 74361522-da01-538d-aa2e-ac7918c6bb92
 *       tenantId: '1234'
 *       tags:
 *         Name: mitt-lags-kanal
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Chatbot Microsoft Teams Channel Configuration using the `team_id`. For example:
 * ```sh
 * $ pulumi import aws:chatbot/teamsChannelConfiguration:TeamsChannelConfiguration example 5f4f15d2-b958-522a-8333-124aa8bf0925
 * ```
 * @property channelId ID of the Microsoft Teams channel.
 * @property channelName Name of the Microsoft Teams channel.
 * @property configurationName Name of the Microsoft Teams channel configuration.
 * @property guardrailPolicyArns List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
 * @property iamRoleArn ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that AWS Chatbot will assume. This is not the service-linked role.
 * @property loggingLevel Logging levels include `ERROR`, `INFO`, or `NONE`.
 * @property snsTopicArns ARNs of the SNS topics that deliver notifications to AWS Chatbot.
 * @property tags Map of tags assigned to the resource.
 * @property teamId ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID from the console.
 * @property teamName Name of the Microsoft Teams team.
 * @property tenantId ID of the Microsoft Teams tenant.
 * The following arguments are optional:
 * @property timeouts
 * @property userAuthorizationRequired Enables use of a user role requirement in your chat configuration.
 */
public data class TeamsChannelConfigurationArgs(
    public val channelId: Output<String>? = null,
    public val channelName: Output<String>? = null,
    public val configurationName: Output<String>? = null,
    public val guardrailPolicyArns: Output<List<String>>? = null,
    public val iamRoleArn: Output<String>? = null,
    public val loggingLevel: Output<String>? = null,
    public val snsTopicArns: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val teamId: Output<String>? = null,
    public val teamName: Output<String>? = null,
    public val tenantId: Output<String>? = null,
    public val timeouts: Output<TeamsChannelConfigurationTimeoutsArgs>? = null,
    public val userAuthorizationRequired: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.chatbot.TeamsChannelConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.chatbot.TeamsChannelConfigurationArgs =
        com.pulumi.aws.chatbot.TeamsChannelConfigurationArgs.builder()
            .channelId(channelId?.applyValue({ args0 -> args0 }))
            .channelName(channelName?.applyValue({ args0 -> args0 }))
            .configurationName(configurationName?.applyValue({ args0 -> args0 }))
            .guardrailPolicyArns(guardrailPolicyArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .iamRoleArn(iamRoleArn?.applyValue({ args0 -> args0 }))
            .loggingLevel(loggingLevel?.applyValue({ args0 -> args0 }))
            .snsTopicArns(snsTopicArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .teamId(teamId?.applyValue({ args0 -> args0 }))
            .teamName(teamName?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userAuthorizationRequired(userAuthorizationRequired?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TeamsChannelConfigurationArgs].
 */
@PulumiTagMarker
public class TeamsChannelConfigurationArgsBuilder internal constructor() {
    private var channelId: Output<String>? = null

    private var channelName: Output<String>? = null

    private var configurationName: Output<String>? = null

    private var guardrailPolicyArns: Output<List<String>>? = null

    private var iamRoleArn: Output<String>? = null

    private var loggingLevel: Output<String>? = null

    private var snsTopicArns: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var teamId: Output<String>? = null

    private var teamName: Output<String>? = null

    private var tenantId: Output<String>? = null

    private var timeouts: Output<TeamsChannelConfigurationTimeoutsArgs>? = null

    private var userAuthorizationRequired: Output<Boolean>? = null

    /**
     * @param value ID of the Microsoft Teams channel.
     */
    @JvmName("brjdeofgjgoqfcvm")
    public suspend fun channelId(`value`: Output<String>) {
        this.channelId = value
    }

    /**
     * @param value Name of the Microsoft Teams channel.
     */
    @JvmName("uddsnuilnlukmvob")
    public suspend fun channelName(`value`: Output<String>) {
        this.channelName = value
    }

    /**
     * @param value Name of the Microsoft Teams channel configuration.
     */
    @JvmName("acelfrrdqbjpphir")
    public suspend fun configurationName(`value`: Output<String>) {
        this.configurationName = value
    }

    /**
     * @param value List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
     */
    @JvmName("guwolcixdmvkrhxi")
    public suspend fun guardrailPolicyArns(`value`: Output<List<String>>) {
        this.guardrailPolicyArns = value
    }

    @JvmName("cpgtacpsmmlrmnpy")
    public suspend fun guardrailPolicyArns(vararg values: Output<String>) {
        this.guardrailPolicyArns = Output.all(values.asList())
    }

    /**
     * @param values List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
     */
    @JvmName("rgfajbuulrogsivt")
    public suspend fun guardrailPolicyArns(values: List<Output<String>>) {
        this.guardrailPolicyArns = Output.all(values)
    }

    /**
     * @param value ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that AWS Chatbot will assume. This is not the service-linked role.
     */
    @JvmName("mnxjwfewrcymlcoo")
    public suspend fun iamRoleArn(`value`: Output<String>) {
        this.iamRoleArn = value
    }

    /**
     * @param value Logging levels include `ERROR`, `INFO`, or `NONE`.
     */
    @JvmName("qrgwhpbvhllemmnw")
    public suspend fun loggingLevel(`value`: Output<String>) {
        this.loggingLevel = value
    }

    /**
     * @param value ARNs of the SNS topics that deliver notifications to AWS Chatbot.
     */
    @JvmName("hiwqusynihckqifd")
    public suspend fun snsTopicArns(`value`: Output<List<String>>) {
        this.snsTopicArns = value
    }

    @JvmName("psjslxvjsfebmidp")
    public suspend fun snsTopicArns(vararg values: Output<String>) {
        this.snsTopicArns = Output.all(values.asList())
    }

    /**
     * @param values ARNs of the SNS topics that deliver notifications to AWS Chatbot.
     */
    @JvmName("xsqevrosjksjivfj")
    public suspend fun snsTopicArns(values: List<Output<String>>) {
        this.snsTopicArns = Output.all(values)
    }

    /**
     * @param value Map of tags assigned to the resource.
     */
    @JvmName("itavsoshafyqtdwp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID from the console.
     */
    @JvmName("tqigdaqralmwwycg")
    public suspend fun teamId(`value`: Output<String>) {
        this.teamId = value
    }

    /**
     * @param value Name of the Microsoft Teams team.
     */
    @JvmName("xlthadxurinlqxhr")
    public suspend fun teamName(`value`: Output<String>) {
        this.teamName = value
    }

    /**
     * @param value ID of the Microsoft Teams tenant.
     * The following arguments are optional:
     */
    @JvmName("cmyavibcglufgoee")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value
     */
    @JvmName("yedyempkcakgersq")
    public suspend fun timeouts(`value`: Output<TeamsChannelConfigurationTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Enables use of a user role requirement in your chat configuration.
     */
    @JvmName("bjcgsbvwvtdljuge")
    public suspend fun userAuthorizationRequired(`value`: Output<Boolean>) {
        this.userAuthorizationRequired = value
    }

    /**
     * @param value ID of the Microsoft Teams channel.
     */
    @JvmName("roqahflgbfaaxuhe")
    public suspend fun channelId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelId = mapped
    }

    /**
     * @param value Name of the Microsoft Teams channel.
     */
    @JvmName("qcioquwvnbinugqa")
    public suspend fun channelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelName = mapped
    }

    /**
     * @param value Name of the Microsoft Teams channel configuration.
     */
    @JvmName("dqnwynifoiumdwyh")
    public suspend fun configurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationName = mapped
    }

    /**
     * @param value List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
     */
    @JvmName("sboiceoeeyucndao")
    public suspend fun guardrailPolicyArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guardrailPolicyArns = mapped
    }

    /**
     * @param values List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
     */
    @JvmName("ihaqdkeegeffselc")
    public suspend fun guardrailPolicyArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.guardrailPolicyArns = mapped
    }

    /**
     * @param value ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that AWS Chatbot will assume. This is not the service-linked role.
     */
    @JvmName("lrjpfikfssdvlvix")
    public suspend fun iamRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRoleArn = mapped
    }

    /**
     * @param value Logging levels include `ERROR`, `INFO`, or `NONE`.
     */
    @JvmName("ybynihkpgffnfgpr")
    public suspend fun loggingLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingLevel = mapped
    }

    /**
     * @param value ARNs of the SNS topics that deliver notifications to AWS Chatbot.
     */
    @JvmName("vkntmhplkmdvwjlc")
    public suspend fun snsTopicArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snsTopicArns = mapped
    }

    /**
     * @param values ARNs of the SNS topics that deliver notifications to AWS Chatbot.
     */
    @JvmName("eekmfrbkvsgxkein")
    public suspend fun snsTopicArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snsTopicArns = mapped
    }

    /**
     * @param value Map of tags assigned to the resource.
     */
    @JvmName("oodqskekxxlmwxyl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the resource.
     */
    @JvmName("sbleqxqcsuahjrrc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID from the console.
     */
    @JvmName("kwopgptiaqjlpsxj")
    public suspend fun teamId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.teamId = mapped
    }

    /**
     * @param value Name of the Microsoft Teams team.
     */
    @JvmName("luyxklntajwlxnhg")
    public suspend fun teamName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.teamName = mapped
    }

    /**
     * @param value ID of the Microsoft Teams tenant.
     * The following arguments are optional:
     */
    @JvmName("myfsccrxfbirbgjp")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value
     */
    @JvmName("edpshyvkdiiyluif")
    public suspend fun timeouts(`value`: TeamsChannelConfigurationTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wumyengyoquskefr")
    public suspend fun timeouts(argument: suspend TeamsChannelConfigurationTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = TeamsChannelConfigurationTimeoutsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    /**
     * @param value Enables use of a user role requirement in your chat configuration.
     */
    @JvmName("mtrqjhiqvbuxikdt")
    public suspend fun userAuthorizationRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAuthorizationRequired = mapped
    }

    internal fun build(): TeamsChannelConfigurationArgs = TeamsChannelConfigurationArgs(
        channelId = channelId,
        channelName = channelName,
        configurationName = configurationName,
        guardrailPolicyArns = guardrailPolicyArns,
        iamRoleArn = iamRoleArn,
        loggingLevel = loggingLevel,
        snsTopicArns = snsTopicArns,
        tags = tags,
        teamId = teamId,
        teamName = teamName,
        tenantId = tenantId,
        timeouts = timeouts,
        userAuthorizationRequired = userAuthorizationRequired,
    )
}
